/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.strings;

import com.google.common.collect.ImmutableList;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.functions.strings.ShannonEntropy;

public class StringEntropy
extends AbstractFunction<Double> {
    public static final String NAME = "string_entropy";
    private final ParameterDescriptor<String, String> valueParam = ParameterDescriptor.string("value").description("The string to compute Shannon Entropy for.").build();

    @Override
    public Double evaluate(FunctionArgs args, EvaluationContext context) {
        String value = this.valueParam.required(args, context);
        return ShannonEntropy.calculateForChars(value);
    }

    @Override
    public FunctionDescriptor<Double> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Double.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.valueParam)).description("Compute Shannon Entropy for the characters within a string.").build();
    }
}

