/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rest;

import com.google.common.base.Strings;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.plugins.pipelineprocessor.processors.ConfigurationStateUpdater;
import org.graylog.plugins.pipelineprocessor.processors.PipelineInterpreter;
import org.graylog.plugins.pipelineprocessor.rest.SimulationRequest;
import org.graylog.plugins.pipelineprocessor.rest.SimulationResponse;
import org.graylog.plugins.pipelineprocessor.simulator.PipelineInterpreterTracer;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.MessageFactory;
import org.graylog2.plugin.Messages;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.rest.models.messages.responses.DecorationStats;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.StreamService;

@Api(value="Pipelines/Simulator", description="Simulate pipeline message processor", tags={"cloud"})
@Path(value="/system/pipelines/simulate")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@RequiresAuthentication
public class SimulatorResource
extends RestResource
implements PluginRestResource {
    private final ConfigurationStateUpdater pipelineStateUpdater;
    private final StreamService streamService;
    private final MessageFactory messageFactory;
    private final PipelineInterpreter pipelineInterpreter;

    @Inject
    public SimulatorResource(PipelineInterpreter pipelineInterpreter, ConfigurationStateUpdater pipelineStateUpdater, StreamService streamService, MessageFactory messageFactory) {
        this.pipelineInterpreter = pipelineInterpreter;
        this.pipelineStateUpdater = pipelineStateUpdater;
        this.streamService = streamService;
        this.messageFactory = messageFactory;
    }

    @ApiOperation(value="Simulate the execution of the pipeline message processor")
    @POST
    @RequiresPermissions(value={"pipeline_rule:read"})
    @NoAuditEvent(value="only used to test pipelines, no changes made in the system")
    public SimulationResponse simulate(@ApiParam(name="simulation", required=true) @NotNull SimulationRequest request) throws NotFoundException {
        this.checkPermission("streams:read", request.streamId());
        Message message = this.messageFactory.createMessage(request.message());
        HashMap<String, Object> originalFields = new HashMap<String, Object>(message.getFields());
        Stream stream = this.streamService.load(request.streamId());
        message.addStream(stream);
        if (!Strings.isNullOrEmpty((String)request.inputId())) {
            message.setSourceInputId(request.inputId());
        }
        ArrayList<ResultMessageSummary> simulationResults = new ArrayList<ResultMessageSummary>();
        PipelineInterpreterTracer pipelineInterpreterTracer = new PipelineInterpreterTracer();
        Messages processedMessages = this.pipelineInterpreter.process(message, pipelineInterpreterTracer.getSimulatorInterpreterListener(), this.pipelineStateUpdater.getLatestState());
        for (Message processedMessage : processedMessages) {
            ResultMessageSummary summary = ResultMessageSummary.create(null, processedMessage.getFields(), "");
            DecorationStats decorationStats = DecorationStats.create(originalFields, processedMessage.getFields());
            simulationResults.add(summary.toBuilder().decorationStats(decorationStats).build());
        }
        return SimulationResponse.create(simulationResults, pipelineInterpreterTracer.getExecutionTrace(), pipelineInterpreterTracer.took());
    }
}

