/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rulebuilder;

import com.google.common.collect.Streams;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graylog.plugins.pipelineprocessor.parser.FunctionRegistry;
import org.graylog.plugins.pipelineprocessor.rulebuilder.db.RuleFragment;
import org.graylog.plugins.pipelineprocessor.rulebuilder.db.RuleFragmentService;

public class RuleBuilderRegistry {
    private final FunctionRegistry functionRegistry;
    private final RuleFragmentService ruleFragmentService;

    @Inject
    public RuleBuilderRegistry(FunctionRegistry functionRegistry, RuleFragmentService ruleFragmentService) {
        this.functionRegistry = functionRegistry;
        this.ruleFragmentService = ruleFragmentService;
    }

    public Map<String, RuleFragment> conditions() {
        Stream<RuleFragment> functionConditions = this.functionRegistry.all().stream().filter(f -> f.descriptor().ruleBuilderEnabled() && f.descriptor().returnType().equals(Boolean.class)).map(f -> RuleFragment.builder().descriptor(f.descriptor()).build());
        Stream<RuleFragment> fragmentConditions = this.ruleFragmentService.all().stream().filter(f -> f.descriptor().ruleBuilderEnabled() && f.isCondition());
        return Streams.concat((Stream[])new Stream[]{functionConditions, fragmentConditions}).collect(Collectors.toMap(f -> f.descriptor().name(), function -> function));
    }

    public Map<String, RuleFragment> actions() {
        Stream<RuleFragment> functions = this.functionRegistry.all().stream().filter(f -> f.descriptor().ruleBuilderEnabled() && !f.descriptor().returnType().equals(Boolean.class)).map(f -> RuleFragment.builder().descriptor(f.descriptor()).build());
        Stream<RuleFragment> fragmentActions = this.ruleFragmentService.all().stream().filter(f -> f.descriptor().ruleBuilderEnabled() && !f.isCondition());
        return Streams.concat((Stream[])new Stream[]{functions, fragmentActions}).collect(Collectors.toMap(f -> f.descriptor().name(), function -> function));
    }
}

