/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rulebuilder.parser;

import freemarker.template.Configuration;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderRegistry;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderStep;
import org.graylog.plugins.pipelineprocessor.rulebuilder.db.RuleFragment;
import org.graylog.plugins.pipelineprocessor.rulebuilder.parser.ParserUtil;
import org.graylog2.bindings.providers.SecureFreemarkerConfigProvider;

@Singleton
public class ConditionParser {
    public static final String NL = System.lineSeparator();
    private static final String INDENT = "  ";
    protected final Map<String, RuleFragment> conditions;
    private final Configuration freemarkerConfiguration;

    @Inject
    public ConditionParser(RuleBuilderRegistry ruleBuilderRegistry, SecureFreemarkerConfigProvider secureFreemarkerConfigProvider) {
        this.conditions = ruleBuilderRegistry.conditions();
        this.freemarkerConfiguration = ParserUtil.initializeFragmentTemplates(secureFreemarkerConfigProvider, this.conditions);
    }

    public Map<String, RuleFragment> getConditions() {
        return this.conditions;
    }

    public String generate(List<RuleBuilderStep> ruleConditions, RuleBuilderStep.Operator operator, int level) {
        if (ruleConditions == null || ruleConditions.isEmpty()) {
            if (level == 1) {
                return "  true";
            }
            return "";
        }
        StringBuilder syntax = new StringBuilder();
        if (level != 1) {
            syntax.append(StringUtils.repeat((String)INDENT, (int)level)).append("(").append(NL);
        }
        for (int i = 0; i < ruleConditions.size(); ++i) {
            RuleBuilderStep step = ruleConditions.get(i);
            syntax.append(this.generateCondition(step, level));
            if (Objects.nonNull(step.conditions()) && !step.conditions().isEmpty() && Objects.nonNull(step.function())) {
                syntax.append(NL).append(StringUtils.repeat((String)INDENT, (int)level)).append((Object)(Objects.nonNull((Object)operator) ? operator : RuleBuilderStep.Operator.AND)).append(NL);
            }
            syntax.append(this.generate(step.conditions(), step.operator(), level + 1));
            if (i == ruleConditions.size() - 1) continue;
            syntax.append(NL).append(StringUtils.repeat((String)INDENT, (int)level)).append((Object)(Objects.nonNull((Object)operator) ? operator : RuleBuilderStep.Operator.AND)).append(NL);
        }
        if (level != 1) {
            syntax.append(NL).append(StringUtils.repeat((String)INDENT, (int)level)).append(")");
        }
        return syntax.toString();
    }

    String generateCondition(RuleBuilderStep step, int level) {
        RuleFragment ruleFragment;
        Object syntax = StringUtils.repeat((String)INDENT, (int)level);
        if (step.negate()) {
            syntax = (String)syntax + "! ";
        }
        if (Objects.isNull(ruleFragment = this.conditions.get(step.function()))) {
            return "";
        }
        FunctionDescriptor function = ruleFragment.descriptor();
        syntax = ruleFragment.isFragment() ? (String)syntax + ParserUtil.generateForFragment(step, this.freemarkerConfiguration) : (String)syntax + ParserUtil.generateForFunction(step, function, level);
        return syntax;
    }

    public String generateConditionVariables(List<RuleBuilderStep> conditions) {
        AtomicInteger index = new AtomicInteger();
        return conditions.stream().map(condition -> this.generateConditionVariable(index.incrementAndGet(), (RuleBuilderStep)condition)).collect(Collectors.joining(NL));
    }

    private String generateConditionVariable(int index, RuleBuilderStep step) {
        String condition = this.generateCondition(step, 0);
        String fieldname = step.outputvariable() == null ? Integer.toString(index) : step.outputvariable();
        return "set_field(\"gl2_simulator_condition_" + fieldname + "\", " + condition + ");";
    }
}

