/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rulebuilder.parser.validation.action;

import jakarta.inject.Inject;
import java.util.Map;
import java.util.Objects;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderRegistry;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderStep;
import org.graylog.plugins.pipelineprocessor.rulebuilder.db.RuleFragment;
import org.graylog.plugins.pipelineprocessor.rulebuilder.parser.validation.ValidationResult;
import org.graylog.plugins.pipelineprocessor.rulebuilder.parser.validation.Validator;
import org.graylog2.shared.utilities.StringUtils;

public class ValidNewMessageField
implements Validator {
    public static final String ERROR_MSG = "New field name: %s must not contain spaces";
    private final Map<String, RuleFragment> actions;

    @Inject
    public ValidNewMessageField(RuleBuilderRegistry ruleBuilderRegistry) {
        this.actions = ruleBuilderRegistry.actions();
    }

    @Override
    public ValidationResult validate(RuleBuilderStep step) {
        RuleFragment ruleFragment = this.actions.get(step.function());
        FunctionDescriptor functionDescriptor = ruleFragment.descriptor();
        String functionName = functionDescriptor.name();
        if (functionName.equals("set_field")) {
            return this.validateSetField(step.parameters());
        }
        return new ValidationResult(false, "");
    }

    private ValidationResult validateSetField(Map<String, Object> parameters) {
        String value = (String)parameters.get("field");
        if (Objects.isNull(value) || org.apache.commons.lang3.StringUtils.containsWhitespace((CharSequence)value)) {
            return new ValidationResult(true, StringUtils.f(ERROR_MSG, value));
        }
        return new ValidationResult(false, "");
    }
}

