/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.filter;

import com.google.inject.assistedinject.Assisted;
import jakarta.inject.Inject;
import org.graylog.plugins.sidecar.filter.AdministrationFilter;
import org.graylog.plugins.sidecar.rest.models.CollectorStatusList;
import org.graylog.plugins.sidecar.rest.models.Sidecar;

public class StatusAdministrationFilter
implements AdministrationFilter {
    private final Sidecar.Status status;

    @Inject
    public StatusAdministrationFilter(@Assisted int status) {
        this.status = Sidecar.Status.fromStatusCode(status);
    }

    @Override
    public boolean test(Sidecar sidecar) {
        CollectorStatusList collectorStatusList = sidecar.nodeDetails().statusList();
        if (collectorStatusList == null) {
            return Sidecar.Status.UNKNOWN.equals((Object)this.status);
        }
        return collectorStatusList.collectors().stream().anyMatch(status -> Sidecar.Status.fromStatusCode(status.status()).equals((Object)this.status));
    }
}

