/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.rest.resources;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.plugins.sidecar.rest.models.CollectorAction;
import org.graylog.plugins.sidecar.rest.models.CollectorActions;
import org.graylog.plugins.sidecar.services.ActionService;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;
import org.hibernate.validator.constraints.NotEmpty;

@Api(value="Sidecar/Collector/Actions", description="Manage Collector actions", tags={"cloud"})
@Path(value="/sidecar/action")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@RequiresAuthentication
public class ActionResource
extends RestResource
implements PluginRestResource {
    private final ActionService actionService;

    @Inject
    public ActionResource(ActionService actionService) {
        this.actionService = actionService;
    }

    @GET
    @Timed
    @Path(value="/{sidecarId}")
    @ApiOperation(value="Returns queued actions for the specified Sidecar id")
    @ApiResponses(value={@ApiResponse(code=404, message="No actions found for specified id")})
    @RequiresPermissions(value={"sidecars:read"})
    public List<CollectorAction> getAction(@ApiParam(name="sidecarId", required=true) @PathParam(value="sidecarId") @NotEmpty String sidecarId) {
        CollectorActions collectorActions = this.actionService.findActionBySidecar(sidecarId, false);
        if (collectorActions != null) {
            return collectorActions.action();
        }
        return new ArrayList<CollectorAction>();
    }

    @PUT
    @Timed
    @Path(value="/{sidecarId}")
    @RequiresPermissions(value={"sidecars:update"})
    @ApiOperation(value="Set a collector action")
    @ApiResponses(value={@ApiResponse(code=400, message="The supplied action is not valid.")})
    @AuditEvent(type="sidecar:action:update")
    public Response setAction(@ApiParam(name="sidecarId", value="The id this Sidecar is registering as.", required=true) @PathParam(value="sidecarId") @NotEmpty String sidecarId, @ApiParam(name="JSON body", required=true) @Valid @NotNull List<CollectorAction> request) {
        CollectorActions collectorActions = this.actionService.fromRequest(sidecarId, request);
        this.actionService.saveAction(collectorActions);
        return Response.accepted().build();
    }
}

