/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.UpdateResult;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.graylog.plugins.views.migrations.AutoValue_V20190805115800_RemoveDashboardStateFromViews_MigrationCompleted;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20190805115800_RemoveDashboardStateFromViews
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20190805115800_RemoveDashboardStateFromViews.class);
    private static final String FIELD_DASHBOARD_STATE = "dashboard_state";
    private static final String FIELD_ID = "_id";
    private final ClusterConfigService clusterConfigService;
    private final MongoCollection<Document> viewsCollection;

    @Inject
    public V20190805115800_RemoveDashboardStateFromViews(ClusterConfigService clusterConfigService, MongoConnection mongoConnection) {
        this.clusterConfigService = clusterConfigService;
        this.viewsCollection = mongoConnection.getMongoDatabase().getCollection("views");
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2019-08-05T11:58:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed.");
            return;
        }
        Set<String> legacyViewIds = StreamSupport.stream(this.viewsCollection.find(Filters.exists((String)FIELD_DASHBOARD_STATE)).spliterator(), false).map(doc -> doc.getObjectId((Object)FIELD_ID)).map(ObjectId::toString).collect(Collectors.toSet());
        UpdateResult updateResult = this.viewsCollection.updateMany(Filters.exists((String)FIELD_DASHBOARD_STATE), Updates.unset((String)FIELD_DASHBOARD_STATE));
        LOG.debug("Migrated " + updateResult.getModifiedCount() + " views.");
        this.clusterConfigService.write(MigrationCompleted.create(updateResult.getModifiedCount(), legacyViewIds));
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonProperty(value="modified_views_count")
        public abstract long modifiedViewsCount();

        @JsonProperty(value="modified_view_ids")
        public abstract Set<String> modifiedViewIds();

        @JsonCreator
        public static MigrationCompleted create(@JsonProperty(value="modified_views_count") long modifiedViews, @JsonProperty(value="modified_view_ids") Set<String> modifiedViewIds) {
            return new AutoValue_V20190805115800_RemoveDashboardStateFromViews_MigrationCompleted(modifiedViews, modifiedViewIds);
        }
    }
}

