/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.db;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchRequirements;
import org.graylog.plugins.views.search.SearchSummary;
import org.graylog.plugins.views.search.searchfilters.db.SearchFiltersReFetcher;
import org.graylog.plugins.views.search.views.PluginMetadataSummary;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedList;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

public class SearchDbService {
    protected final JacksonDBCollection<Search, ObjectId> db;
    protected final JacksonDBCollection<SearchSummary, ObjectId> summarydb;
    private final SearchRequirements.Factory searchRequirementsFactory;
    private final SearchFiltersReFetcher searchFiltersRefetcher;

    @Inject
    protected SearchDbService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, SearchRequirements.Factory searchRequirementsFactory, SearchFiltersReFetcher searchFiltersRefetcher) {
        this.searchRequirementsFactory = searchRequirementsFactory;
        this.db = JacksonDBCollection.wrap(mongoConnection.getDatabase().getCollection("searches"), Search.class, ObjectId.class, mapper.get());
        this.db.createIndex((DBObject)new BasicDBObject("created_at", (Object)1), (DBObject)new BasicDBObject("unique", (Object)false));
        this.summarydb = JacksonDBCollection.wrap(mongoConnection.getDatabase().getCollection("searches"), SearchSummary.class, ObjectId.class, mapper.get());
        this.searchFiltersRefetcher = searchFiltersRefetcher;
    }

    public Optional<Search> get(String id) {
        return Optional.ofNullable(this.db.findOneById(new ObjectId(id))).map(this::getSearchWithRefetchedFilters).map(this::requirementsForSearch);
    }

    private Search getSearchWithRefetchedFilters(Search search) {
        if (this.searchFiltersRefetchNeeded(search)) {
            return search.toBuilder().queries((ImmutableSet<Query>)((ImmutableSet)search.queries().stream().map(query -> query.toBuilder().filters(this.searchFiltersRefetcher.reFetch(query.filters())).build()).collect(ImmutableSet.toImmutableSet()))).build();
        }
        return search;
    }

    private boolean searchFiltersRefetchNeeded(Search search) {
        return this.searchFiltersRefetcher.turnedOn() && search.queries().stream().anyMatch(Query::hasReferencedStreamFilters);
    }

    public Search save(Search search) {
        Search searchToSave = this.requirementsForSearch(search);
        if (searchToSave.id() != null) {
            this.db.update((Bson)DBQuery.is((String)"_id", (Object)search.id()), searchToSave, true, false);
            return searchToSave;
        }
        WriteResult<Search, ObjectId> save = this.db.insert(searchToSave);
        return save.getSavedObject();
    }

    public PaginatedList<Search> findPaginated(DBQuery.Query search, DBSort.SortBuilder sort, int page, int perPage) {
        DBCursor<Search> cursor = this.db.find((Bson)search).sort((Bson)sort).limit(perPage).skip(perPage * Math.max(0, page - 1));
        return new PaginatedList<Search>(Streams.stream(cursor).map(this::getSearchWithRefetchedFilters).map(this::requirementsForSearch).collect(Collectors.toList()), cursor.count(), page, perPage);
    }

    void delete(String id) {
        this.db.removeById(new ObjectId(id));
    }

    public Collection<Search> findByIds(Set<String> idSet) {
        return Streams.stream(this.db.find((Bson)DBQuery.in((String)"_id", (Collection)idSet.stream().map(ObjectId::new).collect(Collectors.toList())))).map(this::getSearchWithRefetchedFilters).map(this::requirementsForSearch).collect(Collectors.toList());
    }

    public Stream<Search> streamAll() {
        return Streams.stream(this.db.find()).map(this::getSearchWithRefetchedFilters).map(this::requirementsForSearch);
    }

    private Search requirementsForSearch(Search search) {
        return this.searchRequirementsFactory.create(search).rebuildRequirements(Search::requires, (s, newRequirements) -> s.toBuilder().requires((Map<String, PluginMetadataSummary>)newRequirements).build());
    }

    Stream<SearchSummary> findSummaries() {
        return Streams.stream(this.summarydb.find());
    }

    public Set<String> getExpiredSearches(Set<String> neverDeleteIds, Instant mustBeOlderThan) {
        return this.findSummaries().filter(search -> !neverDeleteIds.contains(search.id()) && search.createdAt().isBefore((ReadableInstant)mustBeOlderThan)).map(search -> search.id()).collect(Collectors.toSet());
    }
}

