/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.filter.AutoValue_StreamFilter;
import org.graylog.plugins.views.search.filter.OrFilter;

@JsonTypeName(value="stream")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class StreamFilter
implements Filter {
    public static final String NAME = "stream";

    @Override
    @JsonProperty
    public abstract String type();

    @Override
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public abstract Set<Filter> filters();

    @Nullable
    @JsonProperty(value="id")
    public abstract String streamId();

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public abstract String streamTitle();

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    public static StreamFilter ofId(String id) {
        return StreamFilter.builder().streamId(id).build();
    }

    public static Filter anyIdOf(String ... ids) {
        Set streamFilters = Arrays.stream(ids).map(StreamFilter::ofId).collect(Collectors.toSet());
        return ((OrFilter.Builder)OrFilter.builder().filters(streamFilters)).build();
    }

    @Override
    public Filter.Builder toGenericBuilder() {
        return this.toBuilder();
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements Filter.Builder {
        @JsonProperty
        public abstract Builder type(String var1);

        @Override
        @JsonProperty
        public abstract Builder filters(@Nullable Set<Filter> var1);

        @JsonProperty(value="id")
        public abstract Builder streamId(@Nullable String var1);

        @JsonProperty(value="title")
        public abstract Builder streamTitle(@Nullable String var1);

        @Override
        public abstract StreamFilter build();

        @JsonCreator
        public static Builder create() {
            return new AutoValue_StreamFilter.Builder().type(StreamFilter.NAME);
        }
    }
}

