/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.views.QualifyingViewsService;
import org.graylog.plugins.views.search.views.ViewParameterSummaryDTO;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Views/QualifyingViews", tags={"cloud"})
@Path(value="/views/forValue")
@Produces(value={"application/json"})
@RequiresAuthentication
public class QualifyingViewsResource
extends RestResource
implements PluginRestResource {
    private final QualifyingViewsService qualifyingViewsService;

    @Inject
    public QualifyingViewsResource(QualifyingViewsService qualifyingViewsService) {
        this.qualifyingViewsService = qualifyingViewsService;
    }

    @POST
    @ApiOperation(value="Get all views that match given parameter value")
    @NoAuditEvent(value="Only returning matching views, not changing any data")
    public Collection<ViewParameterSummaryDTO> forParameter(@Context SearchUser searchUser) {
        return this.qualifyingViewsService.forValue().stream().filter(searchUser::canReadView).collect(Collectors.toSet());
    }
}

