/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.validation;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.plugins.views.search.validation.LuceneQueryParser;
import org.graylog.plugins.views.search.validation.ParsedQuery;
import org.graylog.plugins.views.search.validation.QueryValidationService;
import org.graylog.plugins.views.search.validation.QueryValidator;
import org.graylog.plugins.views.search.validation.ValidationContext;
import org.graylog.plugins.views.search.validation.ValidationMessage;
import org.graylog.plugins.views.search.validation.ValidationRequest;
import org.graylog.plugins.views.search.validation.ValidationResponse;
import org.graylog.plugins.views.search.validation.validators.ValidationErrors;
import org.graylog2.indexer.fieldtypes.MappedFieldTypesService;

@Singleton
public class QueryValidationServiceImpl
implements QueryValidationService {
    private final LuceneQueryParser luceneQueryParser;
    private final MappedFieldTypesService fields;
    private final Set<QueryValidator> validators;

    @Inject
    public QueryValidationServiceImpl(LuceneQueryParser luceneQueryParser, MappedFieldTypesService fields, Set<QueryValidator> validators) {
        this.luceneQueryParser = luceneQueryParser;
        this.fields = fields;
        this.validators = validators;
    }

    @Override
    public ValidationResponse validate(ValidationRequest req) {
        if (req.isEmptyQuery()) {
            return ValidationResponse.ok();
        }
        try {
            ParsedQuery parsedQuery = this.luceneQueryParser.parse(req.rawQuery());
            ValidationContext context = ValidationContext.builder().request(req).query(parsedQuery).availableFields(this.fields.fieldTypesByStreamIds(req.streams(), req.timerange())).build();
            List<ValidationMessage> explanations = this.validators.stream().flatMap(val -> val.validate(context).stream()).collect(Collectors.toList());
            return ValidationResponse.withDetectedStatus(explanations);
        }
        catch (Exception e) {
            return ValidationResponse.error(ValidationErrors.create(e));
        }
    }
}

