/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.startpage.recentActivities;

import com.google.common.eventbus.EventBus;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import jakarta.inject.Inject;
import java.util.List;
import org.bson.conversions.Bson;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNRegistry;
import org.graylog.grn.GRNType;
import org.graylog.grn.GRNTypes;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.startpage.recentActivities.ActivityType;
import org.graylog.plugins.views.startpage.recentActivities.RecentActivityDTO;
import org.graylog.plugins.views.startpage.recentActivities.RecentActivityEvent;
import org.graylog.security.PermissionAndRoleResolver;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.PaginatedList;
import org.graylog2.plugin.database.users.User;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;

public class RecentActivityService
extends PaginatedDbService<RecentActivityDTO> {
    public static final String COLLECTION_NAME = "recent_activity";
    private final EventBus eventBus;
    private final GRNRegistry grnRegistry;
    private final PermissionAndRoleResolver permissionAndRoleResolver;
    private static final long MAXIMUM_RECENT_ACTIVITIES = 10000L;

    @Inject
    public RecentActivityService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, EventBus eventBus, GRNRegistry grnRegistry, PermissionAndRoleResolver permissionAndRoleResolver) {
        this(mongoConnection, mapper, eventBus, grnRegistry, permissionAndRoleResolver, 10000L);
    }

    protected RecentActivityService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, EventBus eventBus, GRNRegistry grnRegistry, PermissionAndRoleResolver permissionAndRoleResolver, long maximum) {
        super(mongoConnection, mapper, RecentActivityDTO.class, COLLECTION_NAME, BasicDBObjectBuilder.start().add("capped", (Object)true).add("size", (Object)(maximum * 1024L)).add("max", (Object)maximum).get());
        this.grnRegistry = grnRegistry;
        this.permissionAndRoleResolver = permissionAndRoleResolver;
        this.eventBus = eventBus;
        this.db.createIndex((DBObject)new BasicDBObject("item_grn", (Object)1));
    }

    private void postRecentActivity(RecentActivityEvent event) {
        this.eventBus.post((Object)event);
    }

    public void create(String id, GRNType grn, SearchUser user) {
        this.create(id, grn, user.getUser());
    }

    public void create(String id, GRNType grn, User user) {
        this.postRecentActivity(new RecentActivityEvent(ActivityType.CREATE, this.grnRegistry.newGRN(grn, id), user.getFullName()));
    }

    public void update(String id, GRNType grn, SearchUser user) {
        this.update(id, grn, user.getUser());
    }

    public void update(String id, GRNType grn, User user) {
        this.postRecentActivity(new RecentActivityEvent(ActivityType.UPDATE, this.grnRegistry.newGRN(grn, id), user.getFullName()));
    }

    public void delete(String id, GRNType grn, String title, SearchUser user) {
        this.delete(id, grn, title, user.getUser());
    }

    public void delete(String id, GRNType grn, String title, User user) {
        this.postRecentActivity(new RecentActivityEvent(ActivityType.DELETE, this.grnRegistry.newGRN(grn, id), title, user.getFullName()));
    }

    public PaginatedList<RecentActivityDTO> findRecentActivitiesFor(SearchUser user, int page, int perPage) {
        DBSort.SortBuilder sort = this.getSortBuilder("desc", "timestamp");
        if (user.getUser().isLocalAdmin()) {
            return this.findPaginatedWithQueryAndSort((Bson)DBQuery.empty(), (Bson)sort, page, perPage);
        }
        GRN principal = this.grnRegistry.newGRN(GRNTypes.USER, user.getUser().getId());
        List<String> grns = this.permissionAndRoleResolver.resolveGrantees(principal).stream().map(GRN::toString).toList();
        DBQuery.Query query = DBQuery.in((String)"grantee", grns);
        return this.findPaginatedWithQueryAndSort((Bson)query, (Bson)sort, page, perPage);
    }

    public void deleteAllEntriesForEntity(GRN grn) {
        this.db.remove((Bson)DBQuery.is((String)"item_grn", (Object)grn.toString()));
    }
}

