/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.startpage.title;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Optional;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNType;
import org.graylog.grn.GRNTypes;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog.plugins.views.search.views.ViewResolver;
import org.graylog.plugins.views.search.views.ViewResolverDecoder;
import org.graylog2.lookup.Catalog;

@Singleton
public class StartPageItemTitleRetriever {
    private final Catalog catalog;
    private final Map<String, ViewResolver> viewResolvers;

    @Inject
    public StartPageItemTitleRetriever(Catalog catalog, Map<String, ViewResolver> viewResolvers) {
        this.catalog = catalog;
        this.viewResolvers = viewResolvers;
    }

    public Optional<String> retrieveTitle(GRN itemGrn, SearchUser searchUser) {
        Optional<ViewDTO> view;
        ViewResolver viewResolver;
        ViewResolverDecoder decoder;
        if (this.isSpecialView(itemGrn) && (decoder = new ViewResolverDecoder(itemGrn.entity())).isResolverViewId() && (viewResolver = this.viewResolvers.get(decoder.getResolverName())) != null && (view = viewResolver.get(decoder.getViewId())).isPresent() && searchUser.canReadView(view.get())) {
            return Optional.ofNullable(view.get().title());
        }
        Optional<Catalog.Entry> entry = this.catalog.getEntry(itemGrn);
        Optional<String> title = entry.map(Catalog.Entry::title);
        if (title.isPresent()) {
            return title;
        }
        return entry.map(Catalog.Entry::id);
    }

    private boolean isSpecialView(GRN itemGrn) {
        GRNType grnType = itemGrn.grnType();
        String entity = itemGrn.entity();
        return (grnType == GRNTypes.DASHBOARD || grnType == GRNTypes.SEARCH) && entity.contains("__");
    }
}

