/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.joschi.jadconfig.util.Duration;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import one.util.streamex.StreamEx;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog.scheduler.JobTriggerDto;
import org.graylog.scheduler.JobTriggerStatus;
import org.graylog.scheduler.JobTriggerUpdate;
import org.graylog.scheduler.capabilities.SchedulerCapabilitiesService;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoCollections;
import org.graylog2.database.MongoConnection;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.utilities.MongoQueryUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.DBUpdate;
import org.mongojack.JacksonDBCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBJobTriggerService {
    private static final Logger LOG = LoggerFactory.getLogger(DBJobTriggerService.class);
    public static final String COLLECTION_NAME = "scheduler_triggers";
    private static final String FIELD_ID = "_id";
    static final String FIELD_JOB_DEFINITION_ID = "job_definition_id";
    private static final String FIELD_LOCK_OWNER = "lock.owner";
    private static final String FIELD_LAST_LOCK_OWNER = "lock.last_owner";
    private static final String FIELD_PROGRESS = "lock.progress";
    private static final String FIELD_LAST_LOCK_TIME = "lock.last_lock_time";
    private static final String FIELD_NEXT_TIME = "next_time";
    private static final String FIELD_START_TIME = "start_time";
    private static final String FIELD_END_TIME = "end_time";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_SCHEDULE = "schedule";
    private static final String FIELD_DATA = "data";
    private static final String FIELD_UPDATED_AT = "updated_at";
    private static final String FIELD_CONCURRENCY_RESCHEDULE_COUNT = "concurrency_reschedule_count";
    private static final String FIELD_TRIGGERED_AT = "triggered_at";
    private static final String FIELD_CONSTRAINTS = "constraints";
    private static final String FIELD_LAST_EXECUTION_DURATION = "execution_duration";
    private static final String FIELD_IS_CANCELLED = "is_cancelled";
    private static final String FIELD_JOB_DEFINITION_TYPE = "job_definition_type";
    private final String nodeId;
    private final JacksonDBCollection<JobTriggerDto, ObjectId> db;
    private final JobSchedulerClock clock;
    private final SchedulerCapabilitiesService schedulerCapabilitiesService;
    private final Duration lockExpirationDuration;
    private final MongoCollection<JobTriggerDto> collection;

    @Inject
    public DBJobTriggerService(MongoConnection mongoConnection, MongoCollections mongoCollections, MongoJackObjectMapperProvider mapper, NodeId nodeId, JobSchedulerClock clock, SchedulerCapabilitiesService schedulerCapabilitiesService, @Named(value="job_scheduler_lock_expiration_duration") Duration lockExpirationDuration) {
        this.nodeId = nodeId.getNodeId();
        this.clock = clock;
        this.schedulerCapabilitiesService = schedulerCapabilitiesService;
        this.lockExpirationDuration = lockExpirationDuration;
        this.db = JacksonDBCollection.wrap(mongoConnection.getDatabase().getCollection(COLLECTION_NAME), JobTriggerDto.class, ObjectId.class, mapper.get());
        this.collection = mongoCollections.get(COLLECTION_NAME, JobTriggerDto.class);
        this.db.createIndex((DBObject)new BasicDBObject(FIELD_JOB_DEFINITION_ID, (Object)1));
        this.db.createIndex((DBObject)new BasicDBObject(FIELD_LOCK_OWNER, (Object)1));
        this.db.createIndex((DBObject)new BasicDBObject(FIELD_STATUS, (Object)1));
        this.db.createIndex((DBObject)new BasicDBObject(FIELD_START_TIME, (Object)1));
        this.db.createIndex((DBObject)new BasicDBObject(FIELD_END_TIME, (Object)1));
        this.db.createIndex((DBObject)new BasicDBObject(FIELD_NEXT_TIME, (Object)1));
        this.db.createIndex((DBObject)new BasicDBObject(FIELD_CONSTRAINTS, (Object)1));
        this.db.createIndex((DBObject)new BasicDBObject(FIELD_JOB_DEFINITION_TYPE, (Object)1));
    }

    public List<JobTriggerDto> all() {
        return ImmutableList.copyOf(this.db.find().sort((Bson)DBSort.desc((String)FIELD_ID)).iterator());
    }

    public Optional<JobTriggerDto> get(String id) {
        return Optional.ofNullable(this.db.findOneById(new ObjectId(id)));
    }

    public Optional<JobTriggerDto> getOneForJob(String jobDefinitionId) {
        List<JobTriggerDto> triggers = this.getAllForJob(jobDefinitionId);
        if (triggers.size() > 1) {
            throw new IllegalStateException("More than one trigger for job definition <" + jobDefinitionId + ">");
        }
        return triggers.stream().findFirst();
    }

    public List<JobTriggerDto> getAllForJob(String jobDefinitionId) {
        if (Strings.isNullOrEmpty((String)jobDefinitionId)) {
            throw new IllegalArgumentException("jobDefinitionId cannot be null or empty");
        }
        DBQuery.Query query = DBQuery.is((String)FIELD_JOB_DEFINITION_ID, (Object)jobDefinitionId);
        try (DBCursor<JobTriggerDto> cursor = this.db.find((Bson)query);){
            ImmutableList immutableList = ImmutableList.copyOf(cursor.iterator());
            return immutableList;
        }
    }

    public Map<String, List<JobTriggerDto>> getForJobs(Collection<String> jobDefinitionIds) {
        if (jobDefinitionIds == null) {
            throw new IllegalArgumentException("jobDefinitionIds cannot be null");
        }
        Set queryValues = jobDefinitionIds.stream().filter(Objects::nonNull).filter(id -> !Strings.isNullOrEmpty((String)id)).collect(Collectors.toSet());
        DBQuery.Query query = DBQuery.in((String)FIELD_JOB_DEFINITION_ID, queryValues);
        Map groupedTriggers = StreamEx.of(this.db.find((Bson)query).toArray()).groupingBy(JobTriggerDto::jobDefinitionId);
        for (Map.Entry entry : groupedTriggers.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            throw new IllegalStateException("More than one trigger for job definition <" + (String)entry.getKey() + ">");
        }
        return groupedTriggers;
    }

    public JobTriggerDto create(JobTriggerDto trigger) {
        Objects.requireNonNull(trigger, "trigger cannot be null");
        if (trigger.id() != null) {
            throw new IllegalArgumentException("New trigger must not have an ID");
        }
        return this.db.insert(trigger).getSavedObject();
    }

    public boolean update(JobTriggerDto trigger) {
        Optional<Map<String, Object>> scheduleUpdate;
        Objects.requireNonNull(trigger, "trigger cannot be null");
        if (Strings.isNullOrEmpty((String)trigger.id())) {
            throw new IllegalArgumentException("Trigger must have an ID");
        }
        DBUpdate.Builder update = DBUpdate.set((String)FIELD_START_TIME, (Object)trigger.startTime()).set(FIELD_NEXT_TIME, (Object)trigger.nextTime()).set(FIELD_DATA, trigger.data()).set(FIELD_UPDATED_AT, (Object)this.clock.nowUTC()).set(FIELD_CONCURRENCY_RESCHEDULE_COUNT, (Object)trigger.concurrencyRescheduleCount());
        if (trigger.endTime().isPresent()) {
            update.set(FIELD_END_TIME, trigger.endTime());
        }
        if ((scheduleUpdate = trigger.schedule().toDBUpdate("schedule.")).isPresent()) {
            JobTriggerDto oldTrigger = this.get(trigger.id()).orElseThrow(() -> new IllegalStateException("Couldn't find trigger with ID " + trigger.id()));
            Set oldKeys = ((Map)oldTrigger.schedule().toDBUpdate("schedule.").orElse(new HashMap())).keySet();
            Set<String> newKeys = scheduleUpdate.get().keySet();
            Sets.SetView toUnset = Sets.difference(oldKeys, newKeys);
            toUnset.forEach(arg_0 -> ((DBUpdate.Builder)update).unset(arg_0));
            scheduleUpdate.get().forEach((arg_0, arg_1) -> ((DBUpdate.Builder)update).set(arg_0, arg_1));
        }
        return this.db.update((Bson)DBQuery.is((String)FIELD_ID, (Object)this.getId(trigger)), (JobTriggerDto)update).getN() > 0;
    }

    public boolean delete(String triggerId) {
        if (Strings.isNullOrEmpty((String)triggerId)) {
            throw new IllegalArgumentException("triggerId cannot be null or empty");
        }
        return this.db.remove((Bson)DBQuery.is((String)FIELD_ID, (Object)triggerId)).getN() > 0;
    }

    public int deleteCompletedOnceSchedulesOlderThan(long timeValue, TimeUnit unit) {
        DBQuery.Query query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)FIELD_LOCK_OWNER, null), DBQuery.or((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.COMPLETE)), DBQuery.is((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.CANCELLED))}), DBQuery.is((String)"schedule.type", (Object)"once"), DBQuery.lessThan((String)FIELD_UPDATED_AT, (Object)this.clock.nowUTC().minus(unit.toMillis(timeValue)))});
        return this.db.remove((Bson)query).getN();
    }

    public int deleteByQuery(DBQuery.Query query) {
        return this.db.remove((Bson)query).getN();
    }

    public long countByQuery(DBQuery.Query query) {
        return this.db.getCount((Bson)query);
    }

    public Optional<JobTriggerDto> nextRunnableTrigger() {
        DateTime now = this.clock.nowUTC();
        DBQuery.Query constraintsQuery = MongoQueryUtils.getArrayIsContainedQuery(FIELD_CONSTRAINTS, this.schedulerCapabilitiesService.getNodeCapabilities());
        DBQuery.Query query = DBQuery.or((DBQuery.Query[])new DBQuery.Query[]{DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)FIELD_LOCK_OWNER, null), DBQuery.is((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.RUNNABLE)), DBQuery.lessThanEquals((String)FIELD_START_TIME, (Object)now), constraintsQuery, DBQuery.or((DBQuery.Query[])new DBQuery.Query[]{DBQuery.notExists((String)FIELD_END_TIME), DBQuery.is((String)FIELD_END_TIME, null), DBQuery.greaterThan((String)FIELD_END_TIME, Optional.of(now))}), DBQuery.lessThanEquals((String)FIELD_NEXT_TIME, (Object)now)}), DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.notEquals((String)FIELD_LOCK_OWNER, null), DBQuery.notEquals((String)FIELD_LOCK_OWNER, (Object)this.nodeId), DBQuery.is((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.RUNNING)), constraintsQuery, DBQuery.lessThan((String)FIELD_LAST_LOCK_TIME, (Object)now.minus(this.lockExpirationDuration.toMilliseconds()))})});
        DBSort.SortBuilder sort = DBSort.asc((String)FIELD_NEXT_TIME);
        DBUpdate.Builder lockUpdate = DBUpdate.set((String)FIELD_LOCK_OWNER, (Object)this.nodeId).set(FIELD_LAST_LOCK_OWNER, (Object)this.nodeId).set(FIELD_STATUS, (Object)JobTriggerStatus.RUNNING).set(FIELD_TRIGGERED_AT, Optional.of(now)).set(FIELD_LAST_LOCK_TIME, (Object)now);
        JobTriggerDto trigger = this.db.findAndModify((Bson)query, null, (Bson)sort, false, (JobTriggerDto)lockUpdate, true, false);
        return Optional.ofNullable(trigger);
    }

    public boolean releaseTrigger(JobTriggerDto trigger, JobTriggerUpdate triggerUpdate) {
        Objects.requireNonNull(trigger, "trigger cannot be null");
        Objects.requireNonNull(triggerUpdate, "triggerUpdate cannot be null");
        DBQuery.Query query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)FIELD_LOCK_OWNER, (Object)this.nodeId), DBQuery.is((String)FIELD_ID, (Object)this.getId(trigger)), DBQuery.is((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.RUNNING))});
        DBUpdate.Builder update = DBUpdate.unset((String)FIELD_LOCK_OWNER);
        if (triggerUpdate.concurrencyReschedule()) {
            update.inc(FIELD_CONCURRENCY_RESCHEDULE_COUNT);
        } else {
            update.set(FIELD_CONCURRENCY_RESCHEDULE_COUNT, (Object)0);
        }
        if (triggerUpdate.nextTime().isPresent()) {
            if (triggerUpdate.status().isPresent()) {
                update.set(FIELD_STATUS, (Object)triggerUpdate.status().get());
            } else {
                update.set(FIELD_STATUS, (Object)JobTriggerStatus.RUNNABLE);
            }
            update.set(FIELD_NEXT_TIME, (Object)triggerUpdate.nextTime().get());
        } else {
            update.set(FIELD_STATUS, (Object)triggerUpdate.status().orElse(JobTriggerStatus.COMPLETE));
        }
        if (triggerUpdate.data().isPresent()) {
            update.set(FIELD_DATA, triggerUpdate.data());
        }
        trigger.triggeredAt().ifPresent(triggeredAt -> {
            org.joda.time.Duration duration = new org.joda.time.Duration((ReadableInstant)triggeredAt, (ReadableInstant)this.clock.nowUTC());
            update.set(FIELD_LAST_EXECUTION_DURATION, Optional.of(duration.getMillis()));
        });
        int changedDocs = this.db.update((Bson)query, (JobTriggerDto)update).getN();
        if (changedDocs > 1) {
            throw new IllegalStateException("Expected to release only one trigger (id=" + trigger.id() + ") but database query modified " + changedDocs);
        }
        return changedDocs == 1;
    }

    public int forceReleaseOwnedTriggers() {
        DBQuery.Query query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)FIELD_LOCK_OWNER, (Object)this.nodeId), DBQuery.is((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.RUNNING))});
        DBUpdate.Builder update = DBUpdate.unset((String)FIELD_LOCK_OWNER).set(FIELD_STATUS, (Object)JobTriggerStatus.RUNNABLE);
        return this.db.updateMulti((Bson)query, (Bson)update).getN();
    }

    public boolean setTriggerError(JobTriggerDto trigger) {
        Objects.requireNonNull(trigger, "trigger cannot be null");
        DBQuery.Query query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)FIELD_LOCK_OWNER, (Object)this.nodeId), DBQuery.is((String)FIELD_ID, (Object)this.getId(trigger))});
        DBUpdate.Builder update = DBUpdate.unset((String)FIELD_LOCK_OWNER).set(FIELD_STATUS, (Object)JobTriggerStatus.ERROR);
        return this.db.update((Bson)query, (JobTriggerDto)update).getN() > 0;
    }

    private ObjectId getId(JobTriggerDto trigger) {
        return new ObjectId(Objects.requireNonNull(trigger.id(), "trigger ID cannot be null"));
    }

    public void updateLockedJobTriggers() {
        DateTime now = this.clock.nowUTC();
        DBQuery.Query query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)FIELD_LOCK_OWNER, (Object)this.nodeId), DBQuery.is((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.RUNNING))});
        DBUpdate.Builder update = DBUpdate.set((String)FIELD_LAST_LOCK_TIME, (Object)now);
        this.db.updateMulti((Bson)query, (Bson)update);
    }

    public int updateProgress(JobTriggerDto trigger, int progress) {
        DBQuery.Query query = DBQuery.is((String)FIELD_ID, (Object)trigger.id());
        DBUpdate.Builder update = DBUpdate.set((String)FIELD_PROGRESS, (Object)progress);
        return this.db.update((Bson)query, (JobTriggerDto)update).getN();
    }

    public Optional<JobTriggerDto> cancelTriggerByQuery(DBQuery.Query query) {
        DBUpdate.Builder update = DBUpdate.set((String)FIELD_IS_CANCELLED, (Object)true);
        return Optional.ofNullable(this.db.findAndModify((Bson)query, (Bson)update));
    }

    public List<JobTriggerDto> findByQuery(DBQuery.Query query) {
        try (DBCursor<JobTriggerDto> cursor = this.db.find((Bson)query).sort((Bson)DBSort.desc((String)FIELD_UPDATED_AT));){
            ImmutableList immutableList = ImmutableList.copyOf(cursor);
            return immutableList;
        }
    }

    public Map<String, Long> numberOfOverdueTriggers() {
        DateTime now = this.clock.nowUTC();
        AggregateIterable result = this.collection.aggregate(List.of(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.eq((String)FIELD_LOCK_OWNER, null), Filters.eq((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.RUNNABLE)), Filters.lte((String)FIELD_NEXT_TIME, (Object)now), Filters.or((Bson[])new Bson[]{Filters.not((Bson)Filters.exists((String)FIELD_END_TIME)), Filters.eq((String)FIELD_END_TIME, null), Filters.gte((String)FIELD_END_TIME, (Object)now)})})), Aggregates.group((Object)"$job_definition_type", (BsonField[])new BsonField[]{Accumulators.sum((String)"count", (Object)1)})), OverdueTrigger.class);
        return StreamSupport.stream(result.spliterator(), false).collect(Collectors.toMap(OverdueTrigger::type, OverdueTrigger::count));
    }

    private record OverdueTrigger(@JsonProperty(value="_id") String type, @JsonProperty(value="count") long count) {
    }
}

