/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler;

import com.google.inject.assistedinject.Assisted;
import jakarta.inject.Inject;
import java.util.concurrent.TimeUnit;
import org.graylog.scheduler.JobScheduleStrategies;
import org.graylog.scheduler.JobTriggerData;
import org.graylog.scheduler.JobTriggerDto;
import org.graylog.scheduler.JobTriggerUpdate;
import org.graylog.scheduler.clock.JobSchedulerClock;

public class JobTriggerUpdates {
    private final JobSchedulerClock clock;
    private final JobScheduleStrategies scheduleStrategies;
    private final JobTriggerDto trigger;

    @Inject
    public JobTriggerUpdates(JobSchedulerClock clock, JobScheduleStrategies scheduleStrategies, @Assisted JobTriggerDto trigger) {
        this.clock = clock;
        this.scheduleStrategies = scheduleStrategies;
        this.trigger = trigger;
    }

    public JobTriggerUpdate scheduleNextExecution() {
        return JobTriggerUpdate.withNextTime(this.scheduleStrategies.nextTime(this.trigger).orElse(null));
    }

    public JobTriggerUpdate scheduleNextExecution(JobTriggerData data) {
        return JobTriggerUpdate.withNextTimeAndData(this.scheduleStrategies.nextTime(this.trigger).orElse(null), data);
    }

    public JobTriggerUpdate retryIn(long duration, TimeUnit unit) {
        return JobTriggerUpdate.withNextTime(this.clock.nowUTC().plus(unit.toMillis(duration)));
    }

    public static interface Factory {
        public JobTriggerUpdates create(JobTriggerDto var1);
    }
}

