/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import jakarta.inject.Inject;
import org.graylog.scheduler.Job;
import org.graylog.scheduler.JobDefinitionConfig;
import org.graylog.scheduler.JobDefinitionDto;
import org.graylog.scheduler.JobExecutionContext;
import org.graylog.scheduler.JobExecutionException;
import org.graylog.scheduler.JobTriggerStatus;
import org.graylog.scheduler.JobTriggerUpdate;
import org.graylog.security.certutil.AutoValue_CheckForCertRenewalJob_Config;
import org.graylog.security.certutil.CertRenewalService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckForCertRenewalJob
implements Job {
    private static final Logger LOG = LoggerFactory.getLogger(CheckForCertRenewalJob.class);
    public static final String TYPE_NAME = "check-for-cert-renewal-execution-v1";
    public static final String RENEWAL_JOB_ID = "64a66741cb3275652764c937";
    public static final JobDefinitionDto DEFINITION_INSTANCE = JobDefinitionDto.builder().id("64a66741cb3275652764c937").title("Certificat Renewal Check").description("Runs periodically to check for certificates that are about to expire and notifies/triggers renewal").config(Config.builder().build()).build();
    private final CertRenewalService certRenewalService;

    @Inject
    public CheckForCertRenewalJob(CertRenewalService certRenewalService) {
        this.certRenewalService = certRenewalService;
    }

    @Override
    public JobTriggerUpdate execute(JobExecutionContext ctx) throws JobExecutionException {
        LOG.debug("Job execute called {}", (Object)ctx);
        this.certRenewalService.checkCertificatesForRenewal();
        return ctx.jobTriggerUpdates().scheduleNextExecution().toBuilder().status(JobTriggerStatus.RUNNABLE).build();
    }

    @JsonTypeName(value="check-for-cert-renewal-execution-v1")
    @JsonDeserialize(builder=Builder.class)
    @AutoValue
    public static abstract class Config
    implements JobDefinitionConfig {
        public static Builder builder() {
            return Builder.create();
        }

        public abstract Builder toBuilder();

        @AutoValue.Builder
        public static abstract class Builder
        implements JobDefinitionConfig.Builder<Builder> {
            @JsonCreator
            public static Builder create() {
                return new AutoValue_CheckForCertRenewalJob_Config.Builder().type(CheckForCertRenewalJob.TYPE_NAME);
            }

            abstract Config autoBuild();

            public Config build() {
                this.type(CheckForCertRenewalJob.TYPE_NAME);
                return this.autoBuild();
            }
        }
    }

    public static interface Factory
    extends Job.Factory<CheckForCertRenewalJob> {
        @Override
        public CheckForCertRenewalJob create(JobDefinitionDto var1);
    }
}

