/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.keystore.storage;

import jakarta.inject.Inject;
import java.security.KeyStore;
import java.util.Optional;
import org.graylog.security.certutil.ca.exceptions.KeyStoreStorageException;
import org.graylog.security.certutil.keystore.storage.KeystoreContentMover;
import org.graylog.security.certutil.keystore.storage.KeystoreFileStorage;
import org.graylog.security.certutil.keystore.storage.KeystoreMongoStorage;
import org.graylog.security.certutil.keystore.storage.KeystoreStorage;
import org.graylog.security.certutil.keystore.storage.location.KeystoreFileLocation;
import org.graylog.security.certutil.keystore.storage.location.KeystoreLocation;
import org.graylog.security.certutil.keystore.storage.location.KeystoreMongoLocation;
import org.graylog2.cluster.certificates.CertificatesService;

public final class SmartKeystoreStorage
implements KeystoreStorage<KeystoreLocation> {
    private final KeystoreMongoStorage keystoreMongoStorage;
    private final KeystoreFileStorage keystoreFileStorage;

    @Inject
    public SmartKeystoreStorage(CertificatesService certificatesService, KeystoreContentMover keystoreContentMover) {
        this.keystoreMongoStorage = new KeystoreMongoStorage(certificatesService, keystoreContentMover);
        this.keystoreFileStorage = new KeystoreFileStorage(keystoreContentMover);
    }

    @Override
    public void writeKeyStore(KeystoreLocation location, KeyStore keyStore, char[] currentPassword, char[] newPassword) throws KeyStoreStorageException {
        if (location instanceof KeystoreMongoLocation) {
            KeystoreMongoLocation mongoLocation = (KeystoreMongoLocation)location;
            this.keystoreMongoStorage.writeKeyStore(mongoLocation, keyStore, currentPassword, newPassword);
        } else if (location instanceof KeystoreFileLocation) {
            KeystoreFileLocation fileLocation = (KeystoreFileLocation)location;
            this.keystoreFileStorage.writeKeyStore(fileLocation, keyStore, currentPassword, newPassword);
        }
    }

    @Override
    public Optional<KeyStore> readKeyStore(KeystoreLocation location, char[] password) throws KeyStoreStorageException {
        if (location instanceof KeystoreMongoLocation) {
            KeystoreMongoLocation mongoLocation = (KeystoreMongoLocation)location;
            return this.keystoreMongoStorage.readKeyStore(mongoLocation, password);
        }
        if (location instanceof KeystoreFileLocation) {
            KeystoreFileLocation fileLocation = (KeystoreFileLocation)location;
            return this.keystoreFileStorage.readKeyStore(fileLocation, password);
        }
        return Optional.empty();
    }
}

