/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight.web.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.security.KeyStoreException;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.graylog.security.certutil.CaService;
import org.graylog.security.certutil.ca.exceptions.CACreationException;
import org.graylog.security.certutil.ca.exceptions.KeyStoreStorageException;
import org.graylog.security.certutil.csr.ClientCert;
import org.graylog.security.certutil.csr.ClientCertGenerator;
import org.graylog.security.certutil.csr.exceptions.ClientCertGenerationException;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.bootstrap.preflight.web.resources.model.CA;
import org.graylog2.bootstrap.preflight.web.resources.model.CreateCARequest;
import org.graylog2.bootstrap.preflight.web.resources.model.CreateClientCertRequest;
import org.graylog2.plugin.rest.ApiError;

@Path(value="/ca")
@Produces(value={"application/json"})
@RequiresAuthentication
@Api(value="CA", description="Certificate Authority", tags={"cloud"})
public class CAResource {
    private final CaService caService;
    private final String passwordSecret;
    private final ClientCertGenerator clientCertGenerator;

    @Inject
    public CAResource(CaService caService, @Named(value="password_secret") String passwordSecret, ClientCertGenerator clientCertGenerator) {
        this.caService = caService;
        this.passwordSecret = passwordSecret;
        this.clientCertGenerator = clientCertGenerator;
    }

    @GET
    @ApiOperation(value="Returns the CA")
    public CA get() throws KeyStoreStorageException {
        return this.caService.get();
    }

    @POST
    @Path(value="create")
    @AuditEvent(type="graylog_ca:ca:create")
    @ApiOperation(value="Creates a CA")
    @RequiresPermissions(value={"graylog_ca:create"})
    public void createCA(@ApiParam(name="request", required=true) @NotNull @Valid CreateCARequest request) throws CACreationException, KeyStoreStorageException, KeyStoreException {
        this.caService.create(request.organization(), 3650, this.passwordSecret.toCharArray());
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="upload")
    @AuditEvent(type="graylog_ca:ca:upload")
    @ApiOperation(value="Upload a CA")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"graylog_ca:create"})
    public Response uploadCA(@ApiParam(name="password") @FormDataParam(value="password") String password, @ApiParam(name="files") @FormDataParam(value="files") List<FormDataBodyPart> files) {
        try {
            this.caService.upload(password, files);
            return Response.ok().build();
        }
        catch (CACreationException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ApiError.create(e.getMessage())).build();
        }
    }

    @POST
    @Path(value="clientcert")
    @AuditEvent(type="graylog_ca:clientcert:create")
    @ApiOperation(value="Creates a client certificate")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"ca_clientcert:create"})
    public Response createClientCert(@ApiParam(name="request", required=true) @NotNull @Valid CreateClientCertRequest request) {
        try {
            ClientCert cert = this.clientCertGenerator.generateClientCert(request.principal(), request.role(), request.password().toCharArray());
            return Response.ok().entity((Object)cert).build();
        }
        catch (ClientCertGenerationException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ApiError.create(e.getMessage())).build();
        }
    }

    @DELETE
    @Path(value="clientcert/{role}/{principal}")
    @AuditEvent(type="graylog_ca:clientcert:delete")
    @ApiOperation(value="removes the cert and the user from the role")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"ca_clientcert:delete"})
    public Response deleteClientCert(@ApiParam(name="role", required=true) @PathParam(value="role") String role, @ApiParam(name="principal", required=true) @PathParam(value="principal") String principal) {
        try {
            this.clientCertGenerator.removeCertFor(role, principal);
            return Response.ok().build();
        }
        catch (IOException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ApiError.create(e.getMessage())).build();
        }
    }
}

