/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.rest.resources.system.indexer.responses.IndexSetStats;

public class IndexSetStatsCreator {
    private final Indices indices;

    @Inject
    public IndexSetStatsCreator(Indices indices) {
        this.indices = indices;
    }

    public IndexSetStats getForIndexSet(IndexSet indexSet) {
        Set<String> closedIndices = this.indices.getClosedIndices(indexSet);
        List primaries = StreamSupport.stream(this.indices.getIndexStats(indexSet).spliterator(), false).map(json -> json.get("primaries")).collect(Collectors.toList());
        long documents = primaries.stream().map(json -> json.path("docs").path("count").asLong()).reduce(0L, Long::sum);
        long size = primaries.stream().map(json -> json.path("store").path("size_in_bytes").asLong()).reduce(0L, Long::sum);
        return IndexSetStats.create(primaries.size() + closedIndices.size(), documents, size);
    }
}

