/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.datastream.policy.actions;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import org.graylog2.indexer.datastream.policy.actions.Action;
import org.graylog2.indexer.datastream.policy.actions.Retry;
import org.graylog2.indexer.datastream.policy.actions.WrappedAction;

public class ActionDeserializer
extends JsonDeserializer<Action> {
    public Action deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        Retry retry = node.has("retry") ? (Retry)ctxt.readTreeAsValue(node.get("retry"), Retry.class) : null;
        String actionPropertyName = this.findActionPropertyName(node);
        WrappedAction.Type type = WrappedAction.Type.valueOf(actionPropertyName.toUpperCase(Locale.ROOT));
        WrappedAction action = (WrappedAction)ctxt.readTreeAsValue(node.get(actionPropertyName), type.implementingClass);
        return new Action(retry, action);
    }

    private String findActionPropertyName(JsonNode node) {
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            String fieldName = (String)it.next();
            if ("retry".equals(fieldName)) continue;
            return fieldName;
        }
        throw new RuntimeException("Unable to determine the correct ism action");
    }
}

