/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.fieldtypes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.MongoDBUpsertRetryer;
import org.graylog2.indexer.fieldtypes.FieldTypeMapper;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesDTO;
import org.graylog2.indexer.indexset.CustomFieldMappings;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

public class IndexFieldTypesService {
    private static final String FIELDS_FIELD_NAMES = String.format(Locale.US, "%s.%s", "fields", "field_name");
    private final JacksonDBCollection<IndexFieldTypesDTO, ObjectId> db;
    private final MongoCollection<Document> mongoCollection;

    @Inject
    public IndexFieldTypesService(MongoConnection mongoConnection, MongoJackObjectMapperProvider objectMapperProvider) {
        this.mongoCollection = mongoConnection.getMongoDatabase().getCollection("index_field_types");
        this.db = JacksonDBCollection.wrap(mongoConnection.getDatabase().getCollection("index_field_types"), IndexFieldTypesDTO.class, ObjectId.class, objectMapperProvider.get());
        this.db.createIndex((DBObject)new BasicDBObject((Map)ImmutableMap.of((Object)"index_name", (Object)1, (Object)"index_set_id", (Object)1)), (DBObject)new BasicDBObject("unique", (Object)true));
        this.db.createIndex((DBObject)new BasicDBObject("index_name", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
        this.db.createIndex((DBObject)new BasicDBObject(FIELDS_FIELD_NAMES, (Object)1));
        this.db.createIndex((DBObject)new BasicDBObject("index_set_id", (Object)1));
    }

    public List<String> fieldTypeHistory(String indexSetId, String fieldName, boolean skipEntriesWithUnchangedType) {
        AggregateIterable aggregateResult = this.mongoCollection.aggregate(List.of(Aggregates.unwind((String)"$fields"), Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.eq((String)"index_set_id", (Object)indexSetId), Filters.eq((String)"fields.field_name", (Object)fieldName)})), Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{Projections.include((String[])new String[]{"fields.physical_type"}), Projections.excludeId()}))));
        ArrayList<String> typeHistory = new ArrayList<String>();
        aggregateResult.map(document -> ((Document)document.get((Object)"fields")).getString((Object)"physical_type")).map(FieldTypeMapper.TYPE_MAP::get).map(CustomFieldMappings.REVERSE_TYPES::get).forEach(typeHistory::add);
        if (!skipEntriesWithUnchangedType) {
            return typeHistory;
        }
        LinkedList<String> reducedTypeHistory = new LinkedList<String>();
        typeHistory.forEach(type -> {
            if (reducedTypeHistory.isEmpty() || type != null && !type.equals(reducedTypeHistory.getLast())) {
                reducedTypeHistory.add((String)type);
            }
        });
        return reducedTypeHistory;
    }

    public Optional<IndexFieldTypesDTO> get(String idOrIndexName) {
        try {
            return Optional.ofNullable(this.db.findOneById(new ObjectId(idOrIndexName)));
        }
        catch (IllegalArgumentException e) {
            return Optional.ofNullable(this.db.findOne((Bson)DBQuery.is((String)"index_name", (Object)idOrIndexName)));
        }
    }

    public IndexFieldTypesDTO save(IndexFieldTypesDTO dto) {
        WriteResult<IndexFieldTypesDTO, ObjectId> save = this.db.save(dto);
        return save.getSavedObject();
    }

    public Optional<IndexFieldTypesDTO> upsert(IndexFieldTypesDTO dto) {
        WriteResult update = MongoDBUpsertRetryer.run(() -> this.db.update((Bson)DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)"index_name", (Object)dto.indexName()), DBQuery.is((String)"index_set_id", (Object)dto.indexSetId())}), dto, true, false));
        Object upsertedId = update.getUpsertedId();
        if (upsertedId instanceof ObjectId) {
            return this.get(((ObjectId)upsertedId).toHexString());
        }
        if (upsertedId instanceof String) {
            return this.get((String)upsertedId);
        }
        return Optional.empty();
    }

    public void delete(String idOrIndexName) {
        try {
            this.db.removeById(new ObjectId(idOrIndexName));
        }
        catch (IllegalArgumentException e) {
            this.db.remove((Bson)DBQuery.is((String)"index_name", (Object)idOrIndexName));
        }
    }

    public Collection<IndexFieldTypesDTO> findForIndexSet(String indexSetId) {
        return this.findByQuery(DBQuery.is((String)"index_set_id", (Object)indexSetId));
    }

    public Collection<IndexFieldTypesDTO> findForIndexSets(Collection<String> indexSetIds) {
        return this.findByQuery(DBQuery.in((String)"index_set_id", indexSetIds));
    }

    public Collection<IndexFieldTypesDTO> findForFieldNames(Collection<String> fieldNames) {
        return this.findByQuery(DBQuery.in((String)FIELDS_FIELD_NAMES, fieldNames));
    }

    public Collection<IndexFieldTypesDTO> findForFieldNamesAndIndices(Collection<String> fieldNames, Collection<String> indexNames) {
        DBQuery.Query query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.in((String)"index_name", indexNames), DBQuery.in((String)FIELDS_FIELD_NAMES, fieldNames)});
        return this.findByQuery(query);
    }

    public Collection<IndexFieldTypesDTO> findAll() {
        return this.findByQuery(DBQuery.empty());
    }

    private Collection<IndexFieldTypesDTO> findByQuery(DBQuery.Query query) {
        return ImmutableList.copyOf(this.db.find((Bson)query));
    }

    public IndexFieldTypesDTO findOneByIndexName(String indexName) {
        return this.db.findOne((Bson)DBQuery.is((String)"index_name", (Object)indexName));
    }

    public List<IndexFieldTypesDTO> findByIndexNames(Collection<String> indexNames) {
        return this.db.find((Bson)DBQuery.in((String)"index_name", indexNames)).toArray();
    }
}

