/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indexset;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog2.database.DbEntity;
import org.graylog2.datatiering.DataTieringConfig;
import org.graylog2.indexer.indexset.$AutoValue_IndexSetConfig;
import org.graylog2.indexer.indexset.AutoValue_IndexSetConfig;
import org.graylog2.indexer.indexset.CustomFieldMappings;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.graylog2.validation.SizeInBytes;
import org.graylog2.validation.ValidObjectId;
import org.joda.time.Duration;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@JsonAutoDetect
@DbEntity(collection="index_sets", readPermission="indexsets:read")
@AutoValue
public abstract class IndexSetConfig
implements Comparable<IndexSetConfig> {
    public static final String FIELD_INDEX_PREFIX = "index_prefix";
    public static final String FIELD_CREATION_DATE = "creation_date";
    public static final String FIELD_INDEX_TEMPLATE_TYPE = "index_template_type";
    public static final String FIELD_REGULAR = "regular";
    public static final String FIELD_PROFILE_ID = "field_type_profile";
    public static final String FIELD_ROTATION_STRATEGY_CLASS = "rotation_strategy_class";
    public static final String FIELD_ROTATION_STRATEGY = "rotation_strategy";
    public static final String FIELD_RETENTION_STRATEGY_CLASS = "retention_strategy_class";
    public static final String FIELD_RETENTION_STRATEGY = "retention_strategy";
    public static final String FIELD_DATA_TIERING = "data_tiering";
    public static final String INDEX_PREFIX_REGEX = "^[a-z0-9][a-z0-9_+-]*$";
    public static final String DEFAULT_INDEX_TEMPLATE_TYPE = "messages";
    public static final Duration DEFAULT_FIELD_TYPE_REFRESH_INTERVAL = Duration.standardSeconds((long)5L);

    @JsonCreator
    public static IndexSetConfig create(@Id @ObjectId @JsonProperty(value="_id") @Nullable String id, @JsonProperty(value="title") @NotBlank String title, @JsonProperty(value="description") @Nullable String description, @JsonProperty(value="writable") @Nullable Boolean isWritable, @JsonProperty(value="regular") @Nullable Boolean isRegular, @JsonProperty(value="index_prefix") @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") String indexPrefix, @JsonProperty(value="index_match_pattern") @Nullable String indexMatchPattern, @JsonProperty(value="index_wildcard") @Nullable String indexWildcard, @JsonProperty(value="shards") @Min(value=1L) @Min(value=1L) int shards, @JsonProperty(value="replicas") @Min(value=0L) @Min(value=0L) int replicas, @JsonProperty(value="rotation_strategy_class") @Nullable String rotationStrategyClass, @JsonProperty(value="rotation_strategy") @Nullable RotationStrategyConfig rotationStrategy, @JsonProperty(value="retention_strategy_class") @Nullable String retentionStrategyClass, @JsonProperty(value="retention_strategy") @Nullable RetentionStrategyConfig retentionStrategy, @JsonProperty(value="creation_date") @NotNull ZonedDateTime creationDate, @JsonProperty(value="index_analyzer") @Nullable String indexAnalyzer, @JsonProperty(value="index_template_name") @Nullable String indexTemplateName, @JsonProperty(value="index_template_type") @Nullable String indexTemplateType, @JsonProperty(value="index_optimization_max_num_segments") @Nullable Integer maxNumSegments, @JsonProperty(value="index_optimization_disabled") @Nullable Boolean indexOptimizationDisabled, @JsonProperty(value="field_type_refresh_interval") @Nullable Duration fieldTypeRefreshInterval, @JsonProperty(value="custom_field_mappings") @Nullable CustomFieldMappings customFieldMappings, @JsonProperty(value="field_type_profile") @ValidObjectId @Nullable String fieldTypeProfile, @JsonProperty(value="data_tiering") @Nullable DataTieringConfig dataTiering) {
        boolean writableValue = isWritable == null || isWritable != false;
        Duration fieldTypeRefreshIntervalValue = fieldTypeRefreshInterval;
        if (fieldTypeRefreshIntervalValue == null) {
            fieldTypeRefreshIntervalValue = writableValue ? DEFAULT_FIELD_TYPE_REFRESH_INTERVAL : Duration.ZERO;
        }
        return AutoValue_IndexSetConfig.builder().id(id).title(title).description(description).isWritable(writableValue).isRegular(isRegular).indexPrefix(indexPrefix).indexMatchPattern(indexMatchPattern).indexWildcard(indexWildcard).shards(shards).replicas(replicas).rotationStrategyClass(rotationStrategyClass).rotationStrategy(rotationStrategy).retentionStrategyClass(retentionStrategyClass).retentionStrategy(retentionStrategy).creationDate(creationDate).indexAnalyzer(Strings.isNullOrEmpty((String)indexAnalyzer) ? "standard" : indexAnalyzer).indexTemplateName((String)(Strings.isNullOrEmpty((String)indexTemplateName) ? indexPrefix + "-template" : indexTemplateName)).indexTemplateType(indexTemplateType).indexOptimizationMaxNumSegments(maxNumSegments == null ? 1 : maxNumSegments).indexOptimizationDisabled(indexOptimizationDisabled != null && indexOptimizationDisabled != false).fieldTypeRefreshInterval(fieldTypeRefreshIntervalValue).customFieldMappings(customFieldMappings == null ? new CustomFieldMappings() : customFieldMappings).fieldTypeProfile(fieldTypeProfile).dataTiering(dataTiering).build();
    }

    public static IndexSetConfig create(String id, String title, String description, boolean isWritable, Boolean isRegular, String indexPrefix, int shards, int replicas, String rotationStrategyClass, RotationStrategyConfig rotationStrategy, String retentionStrategyClass, RetentionStrategyConfig retentionStrategy, ZonedDateTime creationDate, String indexAnalyzer, String indexTemplateName, String indexTemplateType, int indexOptimizationMaxNumSegments, boolean indexOptimizationDisabled) {
        return IndexSetConfig.create(id, title, description, isWritable, isRegular, indexPrefix, null, null, shards, replicas, rotationStrategyClass, rotationStrategy, retentionStrategyClass, retentionStrategy, creationDate, indexAnalyzer, indexTemplateName, indexTemplateType, indexOptimizationMaxNumSegments, indexOptimizationDisabled, DEFAULT_FIELD_TYPE_REFRESH_INTERVAL, new CustomFieldMappings(), null, null);
    }

    public static IndexSetConfig create(String title, String description, boolean isWritable, Boolean isRegular, String indexPrefix, int shards, int replicas, String rotationStrategyClass, RotationStrategyConfig rotationStrategy, String retentionStrategyClass, RetentionStrategyConfig retentionStrategy, ZonedDateTime creationDate, String indexAnalyzer, String indexTemplateName, String indexTemplateType, int indexOptimizationMaxNumSegments, boolean indexOptimizationDisabled) {
        return IndexSetConfig.create(null, title, description, isWritable, isRegular, indexPrefix, null, null, shards, replicas, rotationStrategyClass, rotationStrategy, retentionStrategyClass, retentionStrategy, creationDate, indexAnalyzer, indexTemplateName, indexTemplateType, indexOptimizationMaxNumSegments, indexOptimizationDisabled, DEFAULT_FIELD_TYPE_REFRESH_INTERVAL, new CustomFieldMappings(), null, null);
    }

    public static Builder builder() {
        return new $AutoValue_IndexSetConfig.Builder().isWritable(true).customFieldMappings(new CustomFieldMappings()).fieldTypeRefreshInterval(DEFAULT_FIELD_TYPE_REFRESH_INTERVAL);
    }

    @JsonProperty(value="id")
    @Nullable
    @Id
    @ObjectId
    public abstract String id();

    @JsonProperty(value="title")
    @NotBlank
    public abstract String title();

    @JsonProperty(value="description")
    @Nullable
    public abstract String description();

    @JsonProperty(value="writable")
    public abstract boolean isWritable();

    @JsonProperty(value="regular")
    public abstract Optional<Boolean> isRegular();

    @JsonProperty(value="index_prefix")
    @NotBlank
    @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$")
    @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250)
    public abstract @NotBlank @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250) String indexPrefix();

    @JsonProperty(value="index_match_pattern")
    @Nullable
    public abstract String indexMatchPattern();

    @JsonProperty(value="index_wildcard")
    @Nullable
    public abstract String indexWildcard();

    @JsonProperty(value="shards")
    @Min(value=1L)
    public abstract @Min(value=1L) int shards();

    @JsonProperty(value="replicas")
    @Min(value=0L)
    public abstract @Min(value=0L) int replicas();

    @JsonProperty(value="rotation_strategy_class")
    @Nullable
    public abstract String rotationStrategyClass();

    @JsonProperty(value="rotation_strategy")
    @Nullable
    public abstract RotationStrategyConfig rotationStrategy();

    @JsonProperty(value="retention_strategy_class")
    @Nullable
    public abstract String retentionStrategyClass();

    @JsonProperty(value="retention_strategy")
    @Nullable
    public abstract RetentionStrategyConfig retentionStrategy();

    @JsonProperty(value="creation_date")
    @NotNull
    public abstract ZonedDateTime creationDate();

    @JsonProperty(value="index_analyzer")
    @NotBlank
    public abstract String indexAnalyzer();

    @JsonProperty(value="index_template_name")
    @NotBlank
    public abstract String indexTemplateName();

    @JsonProperty(value="index_template_type")
    @NotBlank
    public abstract Optional<String> indexTemplateType();

    @JsonProperty(value="index_optimization_max_num_segments")
    @Min(value=1L)
    public abstract @Min(value=1L) int indexOptimizationMaxNumSegments();

    @JsonProperty(value="index_optimization_disabled")
    public abstract boolean indexOptimizationDisabled();

    @JsonProperty(value="field_type_refresh_interval")
    public abstract Duration fieldTypeRefreshInterval();

    @JsonProperty(value="custom_field_mappings")
    public abstract CustomFieldMappings customFieldMappings();

    @JsonProperty(value="field_type_profile")
    @Nullable
    public abstract String fieldTypeProfile();

    @Nullable
    @JsonProperty(value="data_tiering")
    public abstract DataTieringConfig dataTiering();

    @JsonIgnore
    public boolean isRegularIndex() {
        String indexTemplate = this.indexTemplateType().orElse(null);
        return this.isWritable() && (indexTemplate == null || DEFAULT_INDEX_TEMPLATE_TYPE.equals(indexTemplate) || this.isRegular().orElse(false) != false);
    }

    @JsonIgnore
    public boolean canHaveCustomFieldMappings() {
        String indexTemplateType = this.indexTemplateType().orElse(null);
        return !"events".equals(indexTemplateType) && !"failures".equals(indexTemplateType);
    }

    @JsonIgnore
    public boolean canHaveProfile() {
        String indexTemplateType = this.indexTemplateType().orElse(null);
        return !"events".equals(indexTemplateType) && !"failures".equals(indexTemplateType);
    }

    @Override
    public int compareTo(IndexSetConfig o) {
        return ComparisonChain.start().compare((Comparable)((Object)this.title()), (Comparable)((Object)o.title())).compare((Comparable)((Object)this.indexPrefix()), (Comparable)((Object)o.indexPrefix())).compare((Comparable)this.creationDate(), (Comparable)o.creationDate()).result();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder title(String var1);

        public abstract Builder description(String var1);

        public abstract Builder isWritable(boolean var1);

        public abstract Builder isRegular(@Nullable Boolean var1);

        public abstract Builder indexPrefix(String var1);

        public abstract Builder indexMatchPattern(String var1);

        public abstract Builder indexWildcard(String var1);

        public abstract Builder shards(int var1);

        public abstract Builder replicas(int var1);

        public abstract Builder rotationStrategyClass(@Nullable String var1);

        public abstract Builder rotationStrategy(@Nullable RotationStrategyConfig var1);

        public abstract Builder retentionStrategyClass(@Nullable String var1);

        public abstract Builder retentionStrategy(@Nullable RetentionStrategyConfig var1);

        public abstract Builder creationDate(ZonedDateTime var1);

        public abstract Builder indexAnalyzer(String var1);

        public abstract Builder indexTemplateName(String var1);

        public abstract Builder indexTemplateType(@Nullable String var1);

        public abstract Builder indexOptimizationMaxNumSegments(int var1);

        public abstract Builder indexOptimizationDisabled(boolean var1);

        public abstract Builder fieldTypeRefreshInterval(Duration var1);

        public abstract Builder customFieldMappings(CustomFieldMappings var1);

        public abstract Builder fieldTypeProfile(String var1);

        public abstract Builder dataTiering(@Nullable DataTieringConfig var1);

        public abstract IndexSetConfig build();
    }
}

