/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.retention.executors;

import com.google.common.base.Joiner;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.retention.executors.RetentionExecutor;
import org.graylog2.indexer.rotation.tso.IndexLifetimeConfig;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.graylog2.shared.utilities.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeBasedRetentionExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(TimeBasedRetentionExecutor.class);
    private final Indices indices;
    private final JobSchedulerClock clock;
    private final ActivityWriter activityWriter;
    private final RetentionExecutor retentionExecutor;

    @Inject
    public TimeBasedRetentionExecutor(Indices indices, JobSchedulerClock clock, ActivityWriter activityWriter, RetentionExecutor retentionExecutor) {
        this.indices = indices;
        this.clock = clock;
        this.activityWriter = activityWriter;
        this.retentionExecutor = retentionExecutor;
    }

    private static boolean hasCurrentWriteAlias(IndexSet indexSet, Map<String, Set<String>> deflectorIndices, String indexName) {
        return deflectorIndices.getOrDefault(indexName, Collections.emptySet()).contains(indexSet.getWriteIndexAlias());
    }

    public void retain(IndexSet indexSet, IndexLifetimeConfig config, RetentionExecutor.RetentionAction action, String actionName) {
        Map<String, Set<String>> deflectorIndices = indexSet.getAllIndexAliases();
        DateTime now = this.clock.nowUTC();
        long cutoffSoft = now.minus((ReadablePeriod)config.indexLifetimeMin()).getMillis();
        long cutoffHard = now.minus((ReadablePeriod)config.indexLifetimeMax()).getMillis();
        int removeCount = (int)deflectorIndices.keySet().stream().filter(indexName -> !this.indices.isReopened((String)indexName)).filter(indexName -> !TimeBasedRetentionExecutor.hasCurrentWriteAlias(indexSet, deflectorIndices, indexName)).filter(indexName -> this.exceedsAgeLimit((String)indexName, cutoffSoft, cutoffHard)).count();
        if (LOG.isDebugEnabled()) {
            Map<String, Map> debug = deflectorIndices.keySet().stream().collect(Collectors.toMap(k -> k, k -> Map.of("isReopened", this.indices.isReopened((String)k), "hasCurrentWriteAlias", TimeBasedRetentionExecutor.hasCurrentWriteAlias(indexSet, deflectorIndices, k), "exceedsAgeLimit", this.exceedsAgeLimit((String)k, cutoffSoft, cutoffHard), "closingDate", this.indices.indexClosingDate((String)k), "creationDate", this.indices.indexCreationDate((String)k))));
            Joiner.MapJoiner mapJoiner = Joiner.on((String)"\n").withKeyValueSeparator("=");
            LOG.debug("Debug info retain for indexSet <{}>: (min {}, max {}) removeCount: {} details: <{}>", new Object[]{indexSet.getIndexPrefix(), config.indexLifetimeMin(), config.indexLifetimeMax(), removeCount, mapJoiner.join(debug)});
        }
        if (removeCount > 0) {
            String msg = "Running retention for " + removeCount + " aged-out indices.";
            LOG.info(msg);
            this.activityWriter.write(new Activity(msg, TimeBasedRetentionExecutor.class));
            this.retentionExecutor.runRetention(indexSet, removeCount, action, actionName);
        }
    }

    private boolean exceedsAgeLimit(String indexName, long cutoffSoft, long cutoffHard) {
        Optional<DateTime> closingDate = this.indices.indexClosingDate(indexName);
        if (closingDate.isPresent()) {
            return closingDate.get().isBefore(cutoffSoft + 1L);
        }
        Optional<DateTime> creationDate = this.indices.indexCreationDate(indexName);
        if (creationDate.isPresent()) {
            return creationDate.get().isBefore(cutoffHard + 1L);
        }
        LOG.warn(StringUtils.f("Unable to determine creation or closing dates for Index %s - forcing retention", indexName));
        return true;
    }
}

