/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.rotation.tso;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.IndexSetValidator;
import org.graylog2.indexer.rotation.tso.IndexLifetimeConfig;
import org.graylog2.shared.utilities.StringUtils;
import org.joda.time.DurationFieldType;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

public class TimeSizeOptimizingValidator {
    public static Optional<IndexSetValidator.Violation> validate(ElasticsearchConfiguration elasticsearchConfiguration, IndexLifetimeConfig retentionConfig) {
        Period indexLifetimeMin = retentionConfig.indexLifetimeMin();
        Period indexLifetimeMax = retentionConfig.indexLifetimeMax();
        Period leeway = indexLifetimeMax.minus((ReadablePeriod)indexLifetimeMin);
        if (leeway.toStandardSeconds().getSeconds() < 0) {
            return Optional.of(IndexSetValidator.Violation.create(StringUtils.f("%s <%s> is shorter than %s <%s>", "index_lifetime_max", indexLifetimeMax, "index_lifetime_min", indexLifetimeMin)));
        }
        if (leeway.toStandardSeconds().isLessThan(elasticsearchConfiguration.getTimeSizeOptimizingRotationPeriod().toStandardSeconds())) {
            return Optional.of(IndexSetValidator.Violation.create(StringUtils.f("The duration between %s and %s <%s> cannot be shorter than %s <%s>", "index_lifetime_max", "index_lifetime_min", leeway, "time_size_optimizing_rotation_period", elasticsearchConfiguration.getTimeSizeOptimizingRotationPeriod())));
        }
        Period fixedLeeway = elasticsearchConfiguration.getTimeSizeOptimizingRetentionFixedLeeway();
        if (Objects.nonNull(fixedLeeway) && leeway.toStandardSeconds().isLessThan(fixedLeeway.toStandardSeconds())) {
            return Optional.of(IndexSetValidator.Violation.create(StringUtils.f("The duration between %s and %s <%s> cannot be shorter than %s <%s>", "index_lifetime_max", "index_lifetime_min", leeway, "time_size_optimizing_retention_fixed_leeway", fixedLeeway)));
        }
        Period maxRetentionPeriod = elasticsearchConfiguration.getMaxIndexRetentionPeriod();
        if (maxRetentionPeriod != null && indexLifetimeMax.toStandardSeconds().isGreaterThan(maxRetentionPeriod.toStandardSeconds())) {
            return Optional.of(IndexSetValidator.Violation.create(StringUtils.f("Lifetime setting %s <%s> exceeds the configured maximum of %s=%s.", "index_lifetime_max", indexLifetimeMax, "max_index_retention_period", maxRetentionPeriod)));
        }
        if (TimeSizeOptimizingValidator.periodOtherThanDays(indexLifetimeMax) && !elasticsearchConfiguration.allowFlexibleRetentionPeriod()) {
            return Optional.of(IndexSetValidator.Violation.create(StringUtils.f("Lifetime setting %s <%s> can only be a multiple of days", "index_lifetime_max", indexLifetimeMax)));
        }
        if (TimeSizeOptimizingValidator.periodOtherThanDays(indexLifetimeMin) && !elasticsearchConfiguration.allowFlexibleRetentionPeriod()) {
            return Optional.of(IndexSetValidator.Violation.create(StringUtils.f("Lifetime setting %s <%s> can only be a multiple of days", "index_lifetime_min", indexLifetimeMin)));
        }
        return Optional.empty();
    }

    public static boolean periodOtherThanDays(Period period) {
        return Arrays.stream(period.getFieldTypes()).filter(type -> !type.equals(DurationFieldType.days())).anyMatch(type -> period.get(type) != 0);
    }
}

