/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.searches;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog2.indexer.searches.$AutoValue_SearchesClusterConfig;
import org.graylog2.indexer.searches.timerangepresets.TimerangePreset;
import org.joda.time.Period;

@JsonAutoDetect
@AutoValue
public abstract class SearchesClusterConfig {
    private static final Period DEFAULT_QUERY_TIME_RANGE_LIMIT = Period.ZERO;
    private static final Map<Period, String> DEFAULT_RELATIVE_TIMERANGE_OPTIONS = ImmutableMap.builder().put((Object)Period.minutes((int)5), (Object)"5 minutes").put((Object)Period.minutes((int)15), (Object)"15 minutes").put((Object)Period.minutes((int)30), (Object)"30 minutes").put((Object)Period.hours((int)1), (Object)"1 hour").put((Object)Period.hours((int)2), (Object)"2 hours").put((Object)Period.hours((int)8), (Object)"8 hours").put((Object)Period.days((int)1), (Object)"1 day").put((Object)Period.days((int)2), (Object)"2 days").put((Object)Period.days((int)5), (Object)"5 days").put((Object)Period.days((int)7), (Object)"7 days").put((Object)Period.days((int)14), (Object)"14 days").put((Object)Period.days((int)30), (Object)"30 days").put((Object)Period.ZERO, (Object)"all messages").build();
    private static final Map<Period, String> DEFAULT_SURROUNDING_TIMERANGE_OPTIONS = ImmutableMap.builder().put((Object)Period.seconds((int)1), (Object)"1 second").put((Object)Period.seconds((int)5), (Object)"5 seconds").put((Object)Period.seconds((int)10), (Object)"10 seconds").put((Object)Period.seconds((int)30), (Object)"30 seconds").put((Object)Period.minutes((int)1), (Object)"1 minute").put((Object)Period.minutes((int)5), (Object)"5 minutes").build();
    private static final Set<String> DEFAULT_SURROUNDING_FILTER_FIELDS = ImmutableSet.builder().add((Object)"source").add((Object)"gl2_source_input").add((Object)"file").add((Object)"source_file").build();
    private static final Set<String> DEFAULT_ANALYSIS_DISABLED_FIELDS = ImmutableSet.builder().add((Object)"message").add((Object)"full_message").build();
    private static final Map<Period, String> DEFAULT_AUTO_REFRESH_TIMERANGE_OPTIONS = ImmutableMap.builder().put((Object)Period.seconds((int)1), (Object)"1 second").put((Object)Period.seconds((int)2), (Object)"2 second").put((Object)Period.seconds((int)5), (Object)"5 seconds").put((Object)Period.seconds((int)10), (Object)"10 seconds").put((Object)Period.seconds((int)30), (Object)"30 seconds").put((Object)Period.minutes((int)1), (Object)"1 minute").put((Object)Period.minutes((int)5), (Object)"5 minutes").build();
    private static final Period DEFAULT_AUTO_REFRESH_DEFAULT_OPTION = Period.seconds((int)5);

    @JsonProperty(value="quick_access_timerange_presets")
    public abstract List<TimerangePreset> quickAccessTimerangePresets();

    @JsonProperty(value="query_time_range_limit")
    public abstract Period queryTimeRangeLimit();

    @JsonProperty(value="relative_timerange_options")
    public abstract Map<Period, String> relativeTimerangeOptions();

    @JsonProperty(value="surrounding_timerange_options")
    public abstract Map<Period, String> surroundingTimerangeOptions();

    @JsonProperty(value="surrounding_filter_fields")
    public abstract Set<String> surroundingFilterFields();

    @JsonProperty(value="analysis_disabled_fields")
    public abstract Set<String> analysisDisabledFields();

    @JsonProperty(value="auto_refresh_timerange_options")
    public abstract Map<Period, String> autoRefreshTimerangeOptions();

    @JsonProperty(value="default_auto_refresh_option")
    public abstract Period defaultAutoRefreshOption();

    @JsonCreator
    public static SearchesClusterConfig create(@JsonProperty(value="query_time_range_limit") Period queryTimeRangeLimit, @JsonProperty(value="relative_timerange_options") Map<Period, String> relativeTimerangeOptions, @JsonProperty(value="surrounding_timerange_options") Map<Period, String> surroundingTimerangeOptions, @JsonProperty(value="surrounding_filter_fields") Set<String> surroundingFilterFields, @JsonProperty(value="analysis_disabled_fields") @Nullable Set<String> analysisDisabledFields, @JsonProperty(value="auto_refresh_timerange_options") @Nullable Map<Period, String> autoRefreshTimerangeOptions, @JsonProperty(value="default_auto_refresh_option") Period defaultAutoRefreshOption, @JsonProperty(value="quick_access_timerange_presets") @Nullable List<TimerangePreset> quickAccessTimerangePresets) {
        return SearchesClusterConfig.builder().quickAccessTimerangePresets(quickAccessTimerangePresets == null ? List.of() : quickAccessTimerangePresets).queryTimeRangeLimit(queryTimeRangeLimit).relativeTimerangeOptions(relativeTimerangeOptions).surroundingTimerangeOptions(surroundingTimerangeOptions).surroundingFilterFields(surroundingFilterFields).analysisDisabledFields(analysisDisabledFields == null ? DEFAULT_ANALYSIS_DISABLED_FIELDS : analysisDisabledFields).autoRefreshTimerangeOptions(autoRefreshTimerangeOptions == null ? DEFAULT_AUTO_REFRESH_TIMERANGE_OPTIONS : autoRefreshTimerangeOptions).defaultAutoRefreshOption(defaultAutoRefreshOption == null ? DEFAULT_AUTO_REFRESH_DEFAULT_OPTION : defaultAutoRefreshOption).build();
    }

    public static SearchesClusterConfig createDefault() {
        return SearchesClusterConfig.builder().queryTimeRangeLimit(DEFAULT_QUERY_TIME_RANGE_LIMIT).relativeTimerangeOptions(DEFAULT_RELATIVE_TIMERANGE_OPTIONS).surroundingTimerangeOptions(DEFAULT_SURROUNDING_TIMERANGE_OPTIONS).surroundingFilterFields(DEFAULT_SURROUNDING_FILTER_FIELDS).analysisDisabledFields(DEFAULT_ANALYSIS_DISABLED_FIELDS).autoRefreshTimerangeOptions(DEFAULT_AUTO_REFRESH_TIMERANGE_OPTIONS).defaultAutoRefreshOption(DEFAULT_AUTO_REFRESH_DEFAULT_OPTION).quickAccessTimerangePresets(List.of()).build();
    }

    public static Builder builder() {
        return new $AutoValue_SearchesClusterConfig.Builder();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder quickAccessTimerangePresets(List<TimerangePreset> var1);

        public abstract Builder queryTimeRangeLimit(Period var1);

        public abstract Builder relativeTimerangeOptions(Map<Period, String> var1);

        public abstract Builder surroundingTimerangeOptions(Map<Period, String> var1);

        public abstract Builder surroundingFilterFields(Set<String> var1);

        public abstract Builder analysisDisabledFields(Set<String> var1);

        public abstract Builder autoRefreshTimerangeOptions(Map<Period, String> var1);

        public abstract Builder defaultAutoRefreshOption(Period var1);

        public abstract SearchesClusterConfig build();
    }
}

