/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.transports;

import com.github.joschi.jadconfig.util.Size;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.Delimiters;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.graylog2.configuration.TLSProtocolsConfiguration;
import org.graylog2.inputs.transports.NettyTransportConfiguration;
import org.graylog2.inputs.transports.netty.EventLoopGroupFactory;
import org.graylog2.inputs.transports.netty.HttpHandler;
import org.graylog2.inputs.transports.netty.LenientDelimiterBasedFrameDecoder;
import org.graylog2.plugin.LocalMetricRegistry;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.BooleanField;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.NumberField;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.transports.AbstractTcpTransport;
import org.graylog2.plugin.inputs.transports.Transport;
import org.graylog2.plugin.inputs.util.ThroughputCounter;

public class HttpTransport
extends AbstractTcpTransport {
    private static final int DEFAULT_MAX_INITIAL_LINE_LENGTH = 4096;
    private static final int DEFAULT_MAX_HEADER_SIZE = 8192;
    protected static final int DEFAULT_MAX_CHUNK_SIZE = (int)Size.kilobytes((long)64L).toBytes();
    private static final int DEFAULT_IDLE_WRITER_TIMEOUT = 60;
    static final String CK_ENABLE_BULK_RECEIVING = "enable_bulk_receiving";
    static final String CK_ENABLE_CORS = "enable_cors";
    static final String CK_MAX_CHUNK_SIZE = "max_chunk_size";
    static final String CK_IDLE_WRITER_TIMEOUT = "idle_writer_timeout";
    protected final boolean enableBulkReceiving;
    protected final boolean enableCors;
    protected final int maxChunkSize;
    private final int idleWriterTimeout;

    @AssistedInject
    public HttpTransport(@Assisted Configuration configuration, EventLoopGroup eventLoopGroup, EventLoopGroupFactory eventLoopGroupFactory, NettyTransportConfiguration nettyTransportConfiguration, ThroughputCounter throughputCounter, LocalMetricRegistry localRegistry, TLSProtocolsConfiguration tlsConfiguration) {
        super(configuration, throughputCounter, localRegistry, eventLoopGroup, eventLoopGroupFactory, nettyTransportConfiguration, tlsConfiguration);
        this.enableBulkReceiving = configuration.getBoolean(CK_ENABLE_BULK_RECEIVING);
        this.enableCors = configuration.getBoolean(CK_ENABLE_CORS);
        this.maxChunkSize = HttpTransport.parseMaxChunkSize(configuration);
        this.idleWriterTimeout = configuration.intIsSet(CK_IDLE_WRITER_TIMEOUT) ? configuration.getInt(CK_IDLE_WRITER_TIMEOUT, 60) : 60;
    }

    protected static int parseMaxChunkSize(Configuration configuration) {
        int maxChunkSize = configuration.getInt(CK_MAX_CHUNK_SIZE, DEFAULT_MAX_CHUNK_SIZE);
        return maxChunkSize <= 0 ? DEFAULT_MAX_CHUNK_SIZE : maxChunkSize;
    }

    @Override
    protected LinkedHashMap<String, Callable<? extends ChannelHandler>> getCustomChildChannelHandlers(MessageInput input) {
        LinkedHashMap<String, Callable<? extends ChannelHandler>> handlers = new LinkedHashMap<String, Callable<? extends ChannelHandler>>();
        if (this.idleWriterTimeout > 0) {
            handlers.put("read-timeout-handler", () -> new ReadTimeoutHandler((long)this.idleWriterTimeout, TimeUnit.SECONDS));
        }
        handlers.put("decoder", () -> new HttpRequestDecoder(4096, 8192, this.maxChunkSize));
        handlers.put("decompressor", HttpContentDecompressor::new);
        handlers.put("encoder", HttpResponseEncoder::new);
        handlers.put("aggregator", () -> new HttpObjectAggregator(this.maxChunkSize));
        handlers.put("http-handler", () -> new HttpHandler(this.enableCors));
        if (this.enableBulkReceiving) {
            handlers.put("http-bulk-newline-decoder", () -> new LenientDelimiterBasedFrameDecoder(this.maxChunkSize, Delimiters.lineDelimiter()));
        }
        handlers.putAll(super.getCustomChildChannelHandlers(input));
        return handlers;
    }

    @ConfigClass
    public static class Config
    extends AbstractTcpTransport.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest r = super.getRequestedConfiguration();
            r.addField(new BooleanField(HttpTransport.CK_ENABLE_BULK_RECEIVING, "Enable Bulk Receiving", false, "Enables bulk receiving of messages separated by newlines (\\n or \\r\\n)"));
            r.addField(new BooleanField(HttpTransport.CK_ENABLE_CORS, "Enable CORS", true, "Input sends CORS headers to satisfy browser security policies"));
            r.addField(new NumberField(HttpTransport.CK_MAX_CHUNK_SIZE, "Max. HTTP chunk size", DEFAULT_MAX_CHUNK_SIZE, "The maximum HTTP chunk size in bytes (e. g. length of HTTP request body)", ConfigurationField.Optional.OPTIONAL));
            r.addField(new NumberField(HttpTransport.CK_IDLE_WRITER_TIMEOUT, "Idle writer timeout", 60, "The server closes the connection after the given time in seconds after the last client write request. (use 0 to disable)", ConfigurationField.Optional.OPTIONAL, NumberField.Attribute.ONLY_POSITIVE));
            return r;
        }
    }

    @FactoryClass
    public static interface Factory
    extends Transport.Factory<HttpTransport> {
        @Override
        public HttpTransport create(Configuration var1);

        @Override
        public Config getConfig();
    }
}

