/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.messageprocessors;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import jakarta.inject.Inject;
import java.util.List;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.Messages;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.messageprocessors.MessageProcessor;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamMatcherFilterProcessor
implements MessageProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(StreamMatcherFilterProcessor.class);
    private final MetricRegistry metricRegistry;
    private final ServerStatus serverStatus;
    private final StreamRouter streamRouter;

    @Inject
    public StreamMatcherFilterProcessor(MetricRegistry metricRegistry, ServerStatus serverStatus, StreamRouter streamRouter) {
        this.metricRegistry = metricRegistry;
        this.serverStatus = serverStatus;
        this.streamRouter = streamRouter;
    }

    private void route(Message msg) {
        List<Stream> streams = this.streamRouter.route(msg);
        msg.addStreams(streams);
        LOG.debug("Routed message <{}> to {} streams.", (Object)msg.getId(), (Object)streams.size());
    }

    @Override
    public Messages process(Messages messages) {
        for (Message msg : messages) {
            String timerName = MetricRegistry.name((String)"org.graylog2.filters.StreamMatcherFilter", (String[])new String[]{"executionTime"});
            Timer timer = this.metricRegistry.timer(timerName);
            Timer.Context timerContext = timer.time();
            this.route(msg);
            long elapsedNanos = timerContext.stop();
            msg.recordTiming(this.serverStatus, timerName, elapsedNanos);
        }
        return messages;
    }

    public static class Descriptor
    implements MessageProcessor.Descriptor {
        @Override
        public String name() {
            return "Stream Rule Processor";
        }

        @Override
        public String className() {
            return StreamMatcherFilterProcessor.class.getCanonicalName();
        }
    }
}

