/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.auto.value.AutoValue;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog2.messageprocessors.MessageFilterChainProcessor;
import org.graylog2.messageprocessors.MessageProcessorsConfig;
import org.graylog2.messageprocessors.StreamMatcherFilterProcessor;
import org.graylog2.migrations.AutoValue_V20220818112023_AddStreamMatcherToProcessingOrderMigration_MigrationCompleted;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.messageprocessors.MessageProcessor;

public class V20220818112023_AddStreamMatcherToProcessingOrderMigration
extends Migration {
    private final ClusterConfigService clusterConfigService;
    private final Set<String> processorClassNames;

    @Inject
    public V20220818112023_AddStreamMatcherToProcessingOrderMigration(ClusterConfigService clusterConfigService, Set<MessageProcessor.Descriptor> processorDescriptors) {
        this.clusterConfigService = clusterConfigService;
        this.processorClassNames = processorDescriptors.stream().map(MessageProcessor.Descriptor::className).collect(Collectors.toSet());
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2022-08-18T11:20:23Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            return;
        }
        MessageProcessorsConfig config = this.clusterConfigService.getOrDefault(MessageProcessorsConfig.class, MessageProcessorsConfig.defaultConfig());
        List<String> order = config.withProcessors(this.processorClassNames).processorOrder();
        boolean remove = order.remove(StreamMatcherFilterProcessor.class.getCanonicalName());
        if (!remove) {
            throw new IllegalStateException("StreamMatcherFilterProcessor not in processor list");
        }
        int filterChainIndex = order.indexOf(MessageFilterChainProcessor.class.getCanonicalName());
        if (filterChainIndex == -1) {
            throw new IllegalStateException("MessageFilterChainProcessor not in processor list");
        }
        order.add(filterChainIndex + 1, StreamMatcherFilterProcessor.class.getCanonicalName());
        MessageProcessorsConfig newProcessorsConfig = MessageProcessorsConfig.defaultConfig().toBuilder().processorOrder(order).build().withProcessors(this.processorClassNames);
        this.clusterConfigService.write(newProcessorsConfig);
        this.clusterConfigService.write(MigrationCompleted.create());
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonCreator
        public static MigrationCompleted create() {
            return new AutoValue_V20220818112023_AddStreamMatcherToProcessingOrderMigration_MigrationCompleted();
        }
    }
}

