/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.notifications;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import jakarta.inject.Inject;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.streams.events.StreamDeletedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletedStreamNotificationListener {
    private static final Logger LOG = LoggerFactory.getLogger(DeletedStreamNotificationListener.class);
    private final NotificationService notificationService;

    @Inject
    public DeletedStreamNotificationListener(EventBus eventBus, NotificationService notificationService) {
        this.notificationService = notificationService;
        eventBus.register((Object)this);
    }

    @Subscribe
    public void handleStreamDeleted(StreamDeletedEvent streamDeletedEvent) {
        String streamId = streamDeletedEvent.streamId();
        for (Notification notification : this.notificationService.all()) {
            Object rawValue = notification.getDetail("stream_id");
            if (rawValue == null || !rawValue.toString().equals(streamId)) continue;
            LOG.debug("Removing notification that references stream: {}", (Object)notification);
            this.notificationService.destroy(notification);
        }
    }
}

