/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.models.alarmcallbacks.responses;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.graylog2.rest.models.configuration.responses.BooleanField;
import org.graylog2.rest.models.configuration.responses.DropdownField;
import org.graylog2.rest.models.configuration.responses.NumberField;
import org.graylog2.rest.models.configuration.responses.RequestedConfigurationField;
import org.graylog2.rest.models.configuration.responses.TextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvailableAlarmCallbackSummaryResponse {
    private static final Logger LOG = LoggerFactory.getLogger(AvailableAlarmCallbackSummaryResponse.class);
    public String name;
    public Map<String, Map<String, Object>> requested_configuration;

    @JsonIgnore
    public List<RequestedConfigurationField> getRequestedConfiguration() {
        return this.extractRequestedConfiguration(this.requested_configuration);
    }

    public List<RequestedConfigurationField> extractRequestedConfiguration(Map<String, Map<String, Object>> config) {
        ArrayList result = Lists.newArrayList();
        ArrayList booleanFields = Lists.newArrayList();
        block14: for (Map.Entry<String, Map<String, Object>> entry : config.entrySet()) {
            try {
                String fieldType;
                switch (fieldType = (String)entry.getValue().get("type")) {
                    case "text": {
                        result.add(new TextField(entry));
                        continue block14;
                    }
                    case "number": {
                        result.add(new NumberField(entry));
                        continue block14;
                    }
                    case "boolean": {
                        booleanFields.add(new BooleanField(entry));
                        continue block14;
                    }
                    case "dropdown": {
                        result.add(new DropdownField(entry));
                        continue block14;
                    }
                }
                LOG.info("Unknown field type [{}].", (Object)fieldType);
            }
            catch (Exception e) {
                LOG.error("Skipping invalid configuration field [" + entry.getKey() + "]", (Throwable)e);
            }
        }
        result.addAll(booleanFields);
        return result;
    }
}

