/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.models.messages.responses;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.graylog2.rest.models.messages.responses.AutoValue_DecorationStats;
import org.graylog2.rest.models.messages.responses.ChangedField;

@JsonAutoDetect
@AutoValue
public abstract class DecorationStats {
    private static final String FIELD_ADDED_FIELDS = "added_fields";
    private static final String FIELD_CHANGED_FIELDS = "changed_fields";
    private static final String FIELD_REMOVED_FIELDS = "removed_fields";

    @JsonIgnore
    public abstract Map<String, Object> originalMessage();

    @JsonIgnore
    public abstract Map<String, Object> decoratedMessage();

    @JsonProperty(value="added_fields")
    public Map<String, Object> addedFields() {
        return Sets.difference(this.decoratedMessage().keySet(), this.originalMessage().keySet()).stream().collect(Collectors.toMap(Function.identity(), key -> this.decoratedMessage().get(key)));
    }

    @JsonProperty(value="changed_fields")
    public Map<String, Object> changedFields() {
        return Sets.intersection(this.originalMessage().keySet(), this.decoratedMessage().keySet()).stream().filter(key -> !this.originalMessage().get(key).equals(this.decoratedMessage().get(key))).collect(Collectors.toMap(Function.identity(), key -> ChangedField.builder().before(this.originalMessage().get(key)).after(this.decoratedMessage().get(key)).build()));
    }

    @JsonProperty(value="removed_fields")
    public Map<String, Object> removedFields() {
        return Sets.difference(this.originalMessage().keySet(), this.decoratedMessage().keySet()).stream().collect(Collectors.toMap(Function.identity(), key -> this.originalMessage().get(key)));
    }

    public static DecorationStats create(Map<String, Object> originalMessage, Map<String, Object> decoratedMessage) {
        return new AutoValue_DecorationStats(originalMessage, decoratedMessage);
    }
}

