/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.cluster;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.validation.constraints.NotEmpty;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.bson.types.ObjectId;
import org.graylog.scheduler.rest.JobResourceHandlerService;
import org.graylog.security.UserContext;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.rest.models.system.SystemJobSummary;
import org.graylog2.rest.resources.system.jobs.RemoteSystemJobResource;
import org.graylog2.shared.rest.resources.ProxiedResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

@RequiresAuthentication
@Api(value="Cluster/Jobs", description="Cluster-wide System Jobs")
@Path(value="/cluster/jobs")
public class ClusterSystemJobResource
extends ProxiedResource {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterSystemJobResource.class);
    private final JobResourceHandlerService jobResourceHandlerService;
    private final ServerStatus serverStatus;

    @Inject
    public ClusterSystemJobResource(NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, @Context HttpHeaders httpHeaders, @Named(value="proxiedRequestsExecutorService") ExecutorService executorService, JobResourceHandlerService jobResourceHandlerService, ServerStatus serverStatus) throws NodeNotFoundException {
        super(httpHeaders, nodeService, remoteInterfaceProvider, executorService);
        this.jobResourceHandlerService = jobResourceHandlerService;
        this.serverStatus = serverStatus;
    }

    @GET
    @Timed
    @ApiOperation(value="List currently running jobs")
    @Produces(value={"application/json"})
    public Map<String, Optional<Map<String, List<SystemJobSummary>>>> list(@Context UserContext userContext) throws IOException, NodeNotFoundException {
        Map<String, Optional<Map<String, List<SystemJobSummary>>>> forAllNodes = this.stripCallResult(this.requestOnAllNodes(RemoteSystemJobResource.class, RemoteSystemJobResource::list));
        List<SystemJobSummary> jobsFromScheduler = this.jobResourceHandlerService.listJobsAsSystemJobSummary(userContext);
        String thisNodeId = this.serverStatus.getNodeId().toString();
        List jobs = forAllNodes.getOrDefault(thisNodeId, Optional.empty()).orElse(Collections.emptyMap()).getOrDefault("jobs", new ArrayList());
        jobs.addAll(jobsFromScheduler);
        forAllNodes.put(thisNodeId, Optional.of(ImmutableMap.of((Object)"jobs", (Object)jobs)));
        return forAllNodes;
    }

    @GET
    @Path(value="{jobId}")
    @Timed
    @ApiOperation(value="Get job with the given ID")
    @Produces(value={"application/json"})
    public SystemJobSummary getJob(@Context UserContext userContext, @ApiParam(name="jobId", required=true) @PathParam(value="jobId") String jobId) throws IOException {
        Optional<SystemJobSummary> job;
        for (Map.Entry<String, Node> entry : this.nodeService.allActive().entrySet()) {
            RemoteSystemJobResource remoteSystemJobResource = this.remoteInterfaceProvider.get(entry.getValue(), this.getAuthenticationToken(), RemoteSystemJobResource.class);
            try {
                Response response = remoteSystemJobResource.get(jobId).execute();
                if (!response.isSuccessful()) continue;
                return (SystemJobSummary)response.body();
            }
            catch (IOException e) {
                LOG.warn("Unable to fetch system jobs from node {}:", (Object)entry.getKey(), (Object)e);
            }
        }
        if (ObjectId.isValid((String)jobId) && (job = this.jobResourceHandlerService.getJobAsSystemJobSummery(userContext, jobId)).isPresent()) {
            return job.get();
        }
        throw new NotFoundException("System job with id " + jobId + " not found!");
    }

    @DELETE
    @Path(value="{jobId}")
    @Timed
    @ApiOperation(value="Cancel job with the given ID")
    @Produces(value={"application/json"})
    @AuditEvent(type="server:system_job:stop")
    public SystemJobSummary cancelJob(@Context UserContext userContext, @ApiParam(name="jobId", required=true) @PathParam(value="jobId") @NotEmpty String jobId) throws IOException {
        Optional<Response> summaryResponse = this.nodeService.allActive().entrySet().stream().map(entry -> {
            RemoteSystemJobResource resource = this.remoteInterfaceProvider.get((Node)entry.getValue(), this.getAuthenticationToken(), RemoteSystemJobResource.class);
            try {
                return resource.delete(jobId).execute();
            }
            catch (IOException e) {
                LOG.warn("Unable to fetch system jobs from node {}:", entry.getKey(), (Object)e);
                return null;
            }
        }).filter(response -> response != null && response.isSuccessful()).findFirst();
        if (!summaryResponse.isPresent() && ObjectId.isValid((String)jobId)) {
            Optional<SystemJobSummary> systemJobSummary = this.jobResourceHandlerService.cancelJobWithSystemJobSummary(userContext, jobId);
            return systemJobSummary.orElseThrow(() -> new NotFoundException("System job with ID <" + jobId + "> not found!"));
        }
        return (SystemJobSummary)summaryResponse.orElseThrow(() -> new NotFoundException("System job with ID <" + jobId + "> not found!")).body();
    }
}

