/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.search;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotEmpty;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.glassfish.jersey.server.ChunkedOutput;
import org.graylog.plugins.views.search.engine.SearchExecutor;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.searchtypes.Sort;
import org.graylog2.decorators.DecoratorProcessor;
import org.graylog2.indexer.results.ChunkedResult;
import org.graylog2.indexer.results.ResultChunk;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.rest.RestTools;
import org.graylog2.rest.resources.search.SearchResource;
import org.graylog2.rest.resources.search.responses.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Legacy/Search/Absolute", description="Message search", tags={"cloud"})
@Path(value="/search/universal/absolute")
public class AbsoluteSearchResource
extends SearchResource {
    private static final Logger LOG = LoggerFactory.getLogger(AbsoluteSearchResource.class);

    @Inject
    public AbsoluteSearchResource(Searches searches, SearchExecutor searchExecutor, ClusterConfigService clusterConfigService, DecoratorProcessor decoratorProcessor) {
        super(searches, clusterConfigService, decoratorProcessor, searchExecutor);
    }

    @GET
    @Timed
    @ApiOperation(value="Message search with absolute timerange.", notes="Search for messages using an absolute timerange, specified as from/to with format yyyy-MM-ddTHH:mm:ss.SSSZ (e.g. 2014-01-23T15:34:49.000Z) or yyyy-MM-dd HH:mm:ss.")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid timerange parameters provided.")})
    public SearchResponse searchAbsolute(@ApiParam(name="query", value="Query (Lucene syntax)", required=true) @QueryParam(value="query") @NotEmpty String query, @ApiParam(name="from", value="Timerange start. See description for date format", required=true) @QueryParam(value="from") @NotEmpty String from, @ApiParam(name="to", value="Timerange end. See description for date format", required=true) @QueryParam(value="to") @NotEmpty String to, @ApiParam(name="limit", value="Maximum number of messages to return.") @QueryParam(value="limit") int limit, @ApiParam(name="offset", value="Offset") @QueryParam(value="offset") int offset, @ApiParam(name="filter", value="Filter") @QueryParam(value="filter") String filter, @ApiParam(name="fields", value="Comma separated list of fields to return") @QueryParam(value="fields") String fields, @ApiParam(name="sort", value="Sorting (field:asc / field:desc)") @QueryParam(value="sort") String sort, @ApiParam(name="decorate", value="Run decorators on search result") @QueryParam(value="decorate") @DefaultValue(value="true") boolean decorate, @Context SearchUser searchUser) {
        this.checkSearchPermission(filter, "searches:absolute");
        Sort sorting = this.buildSortOrder(sort);
        List<String> fieldList = this.parseOptionalFields(fields);
        TimeRange timeRange = this.buildAbsoluteTimeRange(from, to);
        return this.search(query, limit, offset, filter, decorate, searchUser, fieldList, sorting, timeRange);
    }

    @GET
    @Timed
    @ApiOperation(value="Message search with absolute timerange.", notes="Search for messages using an absolute timerange, specified as from/to with format yyyy-MM-ddTHH:mm:ss.SSSZ (e.g. 2014-01-23T15:34:49.000Z) or yyyy-MM-dd HH:mm:ss.")
    @Produces(value={"text/csv"})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid timerange parameters provided.")})
    public ChunkedOutput<ResultChunk> searchAbsoluteChunked(@ApiParam(name="query", value="Query (Lucene syntax)", required=true) @QueryParam(value="query") @NotEmpty String query, @ApiParam(name="from", value="Timerange start. See description for date format", required=true) @QueryParam(value="from") @NotEmpty String from, @ApiParam(name="to", value="Timerange end. See description for date format", required=true) @QueryParam(value="to") @NotEmpty String to, @ApiParam(name="limit", value="Maximum number of messages to return.", required=false) @QueryParam(value="limit") int limit, @ApiParam(name="offset", value="Offset", required=false) @QueryParam(value="offset") int offset, @ApiParam(name="batch_size", value="Batch size for the backend storage export request.", required=false) @QueryParam(value="batch_size") @DefaultValue(value="500") int batchSize, @ApiParam(name="filter", value="Filter", required=false) @QueryParam(value="filter") String filter, @ApiParam(name="fields", value="Comma separated list of fields to return", required=true) @QueryParam(value="fields") @NotEmpty String fields) {
        this.checkSearchPermission(filter, "searches:absolute");
        List<String> fieldList = this.parseFields(fields);
        TimeRange timeRange = this.buildAbsoluteTimeRange(from, to);
        ChunkedResult scroll = this.searches.scroll(query, timeRange, limit, offset, fieldList, filter, batchSize);
        return this.buildChunkedOutput(scroll);
    }

    @GET
    @Path(value="/export")
    @Timed
    @ApiOperation(value="Export message search with absolute timerange.", notes="Search for messages using an absolute timerange, specified as from/to with format yyyy-MM-ddTHH:mm:ss.SSSZ (e.g. 2014-01-23T15:34:49.000Z) or yyyy-MM-dd HH:mm:ss.")
    @Produces(value={"text/csv"})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid timerange parameters provided.")})
    public Response exportSearchAbsoluteChunked(@ApiParam(name="query", value="Query (Lucene syntax)", required=true) @QueryParam(value="query") @NotEmpty String query, @ApiParam(name="from", value="Timerange start. See description for date format", required=true) @QueryParam(value="from") @NotEmpty String from, @ApiParam(name="to", value="Timerange end. See description for date format", required=true) @QueryParam(value="to") @NotEmpty String to, @ApiParam(name="limit", value="Maximum number of messages to return.", required=false) @QueryParam(value="limit") int limit, @ApiParam(name="offset", value="Offset", required=false) @QueryParam(value="offset") int offset, @ApiParam(name="batch_size", value="Batch size for the backend storage export request.", required=false) @QueryParam(value="batch_size") @DefaultValue(value="500") int batchSize, @ApiParam(name="filter", value="Filter", required=false) @QueryParam(value="filter") String filter, @ApiParam(name="fields", value="Comma separated list of fields to return", required=true) @QueryParam(value="fields") @NotEmpty String fields) {
        this.checkSearchPermission(filter, "searches:absolute");
        String filename = "graylog-search-result-absolute-" + from + "-" + to + ".csv";
        return RestTools.respondWithFile(filename, this.searchAbsoluteChunked(query, from, to, limit, offset, batchSize, filter, fields)).build();
    }

    private TimeRange buildAbsoluteTimeRange(String from, String to) {
        try {
            return this.restrictTimeRange(AbsoluteRange.create(from, to));
        }
        catch (InvalidRangeParametersException e) {
            LOG.warn("Invalid timerange parameters provided. Returning HTTP 400.");
            throw new BadRequestException("Invalid timerange parameters provided", (Throwable)e);
        }
    }
}

