/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jakarta.inject.Inject;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.plugin.ProcessingPauseLockedException;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/Processing", description="System processing status control.")
@Path(value="/system/processing")
public class SystemProcessingResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(SystemProcessingResource.class);
    private final ServerStatus serverStatus;

    @Inject
    public SystemProcessingResource(ServerStatus serverStatus) {
        this.serverStatus = serverStatus;
    }

    @PUT
    @Timed
    @ApiOperation(value="Pauses message processing", notes="If the message journal is enabled, incoming messages will be spooled on disk, if it is disabled, you might lose messages from inputs which cannot buffer themselves, like AMQP or Kafka-based inputs.")
    @Path(value="pause")
    @AuditEvent(type="server:message_processing:stop")
    public void pauseProcessing() {
        this.checkPermission("processing:changestate", this.serverStatus.getNodeId().toString());
        this.serverStatus.pauseMessageProcessing(false);
        LOG.info("Paused message processing - triggered by REST call.");
    }

    @PUT
    @Timed
    @ApiOperation(value="Resume message processing")
    @Path(value="resume")
    @AuditEvent(type="server:message_processing:start")
    public void resumeProcessing() {
        this.checkPermission("processing:changestate", this.serverStatus.getNodeId().toString());
        try {
            this.serverStatus.resumeMessageProcessing();
        }
        catch (ProcessingPauseLockedException e) {
            LOG.error("Message processing pause is locked. Returning HTTP 403.");
            throw new ForbiddenException((Throwable)e);
        }
        LOG.info("Resumed message processing - triggered by REST call.");
    }

    @PUT
    @Timed
    @Path(value="pause/unlock")
    @AuditEvent(type="server:message_processing:unlock")
    public void unlockProcessingPause() {
        this.checkPermission("processing:changestate", this.serverStatus.getNodeId().toString());
        this.serverStatus.unlockProcessingPause();
        LOG.info("Manually unlocked message processing pause - triggered by REST call.");
    }
}

