/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.inputs;

import com.codahale.metrics.annotation.Timed;
import com.google.common.eventbus.EventBus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.inject.Inject;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.inputs.Input;
import org.graylog2.inputs.InputService;
import org.graylog2.plugin.IOState;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.rest.models.system.inputs.responses.InputCreated;
import org.graylog2.rest.models.system.inputs.responses.InputDeleted;
import org.graylog2.rest.models.system.inputs.responses.InputStateSummary;
import org.graylog2.rest.models.system.inputs.responses.InputStatesList;
import org.graylog2.rest.models.system.inputs.responses.InputSummary;
import org.graylog2.rest.resources.system.inputs.AbstractInputsResource;
import org.graylog2.shared.inputs.InputRegistry;
import org.graylog2.shared.inputs.MessageInputFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/InputStates", description="Message input states of this node")
@Path(value="/system/inputstates")
@Produces(value={"application/json"})
public class InputStatesResource
extends AbstractInputsResource {
    private static final Logger LOG = LoggerFactory.getLogger(InputStatesResource.class);
    private final InputRegistry inputRegistry;
    private final EventBus serverEventBus;
    private final InputService inputService;

    @Inject
    public InputStatesResource(InputRegistry inputRegistry, EventBus serverEventBus, InputService inputService, MessageInputFactory messageInputFactory) {
        super(messageInputFactory.getAvailableInputs());
        this.inputRegistry = inputRegistry;
        this.serverEventBus = serverEventBus;
        this.inputService = inputService;
    }

    @GET
    @Timed
    @ApiOperation(value="Get all input states of this node")
    public InputStatesList list() {
        Set<InputStateSummary> result = this.inputRegistry.stream().filter(inputState -> this.isPermitted("inputs:read", ((MessageInput)inputState.getStoppable()).getId())).map(this::getInputStateSummary).collect(Collectors.toSet());
        return InputStatesList.create(result);
    }

    @GET
    @Path(value="/{inputId}")
    @Timed
    @ApiOperation(value="Get input state for specified input id on this node")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node.")})
    public InputStateSummary get(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) {
        this.checkPermission("inputs:read", inputId);
        IOState<MessageInput> inputState = this.inputRegistry.getInputState(inputId);
        if (inputState == null) {
            throw new NotFoundException("No input state for input id <" + inputId + "> on this node.");
        }
        return this.getInputStateSummary(inputState);
    }

    @PUT
    @Path(value="/{inputId}")
    @Timed
    @ApiOperation(value="(Re-)Start specified input on this node")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node.")})
    @AuditEvent(type="server:message_input:start")
    public InputCreated start(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:changestate", inputId);
        Input input = this.inputService.find(inputId);
        this.persistDesiredState(input, IOState.Type.RUNNING);
        InputCreated result = InputCreated.create(inputId);
        this.serverEventBus.post((Object)result);
        return result;
    }

    @DELETE
    @Path(value="/{inputId}")
    @Timed
    @ApiOperation(value="Stop specified input on this node")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node.")})
    @AuditEvent(type="server:message_input:stop")
    public InputDeleted stop(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:changestate", inputId);
        Input input = this.inputService.find(inputId);
        this.persistDesiredState(input, IOState.Type.STOPPED);
        InputDeleted result = InputDeleted.create(inputId);
        this.serverEventBus.post((Object)result);
        return result;
    }

    private InputStateSummary getInputStateSummary(IOState<MessageInput> inputState) {
        MessageInput messageInput = inputState.getStoppable();
        return InputStateSummary.create(messageInput.getId(), inputState.getState().toString(), inputState.getStartedAt(), inputState.getDetailedMessage(), InputSummary.create(messageInput.getTitle(), messageInput.isGlobal(), messageInput.getName(), messageInput.getContentPack(), messageInput.getId(), messageInput.getCreatedAt(), messageInput.getType(), messageInput.getCreatorUserId(), this.maskPasswordsInConfiguration(messageInput.getConfiguration().getSource(), messageInput.getRequestedConfiguration()), messageInput.getStaticFields(), messageInput.getNodeId()));
    }

    private void persistDesiredState(Input input, IOState.Type desiredState) {
        try {
            input.setDesiredState(desiredState);
            this.inputService.saveWithoutEvents(input);
        }
        catch (ValidationException e) {
            LOG.error("Missing or invalid input configuration.", (Throwable)e);
            throw new BadRequestException("Missing or invalid input configuration.", (Throwable)e);
        }
    }
}

