/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.monitoring;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.plugins.views.search.engine.QueryExecutionStats;
import org.graylog.plugins.views.search.engine.monitoring.collection.StatsCollector;
import org.graylog.plugins.views.search.engine.monitoring.data.histogram.Histogram;
import org.graylog.plugins.views.search.engine.monitoring.data.histogram.creation.AverageValueComputation;
import org.graylog.plugins.views.search.engine.monitoring.data.histogram.creation.MaxValueComputation;
import org.graylog.plugins.views.search.engine.monitoring.data.histogram.creation.MultiValueSingleInputHistogramCreation;
import org.graylog.plugins.views.search.engine.monitoring.data.histogram.creation.PercentageValueComputation;
import org.graylog.plugins.views.search.engine.monitoring.data.histogram.creation.PeriodBasedBinChooser;
import org.graylog2.indexer.searches.SearchesClusterConfig;
import org.graylog2.shared.rest.resources.RestResource;
import org.joda.time.Period;

@RequiresAuthentication
@Api(value="System/Monitoring", tags={"cloud"})
@Path(value="/system/monitoring")
public class MonitoringResource
extends RestResource {
    public static final String AVG_FUNCTION_NAME = "Avg. duration (ms)";
    public static final String MAX_FUNCTION_NAME = "Max. duration (ms)";
    public static final String PERCENT_FUNCTION_NAME = "Percent. of recent queries";
    public static final String TIMERANGE = "Timerange";
    private final StatsCollector<QueryExecutionStats> executionStatsCollector;
    private final MultiValueSingleInputHistogramCreation<Period, QueryExecutionStats> histogramCreator;

    @Inject
    public MonitoringResource(StatsCollector<QueryExecutionStats> executionStatsCollector) {
        this.executionStatsCollector = executionStatsCollector;
        LinkedHashMap valueFunctions = new LinkedHashMap();
        valueFunctions.put(AVG_FUNCTION_NAME, new AverageValueComputation<QueryExecutionStats>(QueryExecutionStats::duration));
        valueFunctions.put(MAX_FUNCTION_NAME, new MaxValueComputation<QueryExecutionStats>(QueryExecutionStats::duration));
        valueFunctions.put(PERCENT_FUNCTION_NAME, new PercentageValueComputation());
        this.histogramCreator = new MultiValueSingleInputHistogramCreation<Period, QueryExecutionStats>(new ArrayList<Period>(SearchesClusterConfig.createDefault().relativeTimerangeOptions().keySet()), new PeriodBasedBinChooser(), valueFunctions, TIMERANGE);
    }

    @GET
    @Timed
    @ApiOperation(value="Get timerange-based histogram of queries durations and percentage in recent query population")
    @Path(value="query_duration_histogram")
    @Produces(value={"application/json", "text/csv"})
    @RequiresPermissions(value={"monitoring:read"})
    public Histogram getQueryDurationHistogram() {
        List<QueryExecutionStats> allStats = this.executionStatsCollector.getAllStats();
        return this.histogramCreator.create(allStats);
    }
}

