/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.search;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.graylog2.rest.resources.entities.EntityAttribute;
import org.graylog2.search.SearchQueryField;

public class DbFieldMappingCreator {
    public static Map<String, SearchQueryField> createFromEntityAttributes(List<EntityAttribute> attributes) {
        HashMap<String, SearchQueryField> dbFieldMapping = new HashMap<String, SearchQueryField>();
        attributes.stream().filter(attr -> Objects.nonNull(attr.searchable())).filter(EntityAttribute::searchable).forEach(attr -> {
            SearchQueryField searchQueryField = SearchQueryField.create(attr.id(), attr.type());
            dbFieldMapping.put(attr.id(), searchQueryField);
            if (!attr.title().contains(" ")) {
                dbFieldMapping.put(attr.title().toLowerCase(Locale.ROOT), searchQueryField);
            }
        });
        return dbFieldMapping;
    }
}

