/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.codahale.metrics.MetricRegistry;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.primitives.Ints;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;
import org.graylog2.metrics.CacheStatsSet;
import org.graylog2.shared.metrics.MetricUtils;

@Singleton
public class MongoDbAuthorizationCacheManager
implements CacheManager {
    private final MetricRegistry registry;

    @Inject
    public MongoDbAuthorizationCacheManager(MetricRegistry registry) {
        this.registry = registry;
    }

    public <K, V> org.apache.shiro.cache.Cache<K, V> getCache(String name) throws CacheException {
        return new GuavaCacheWrapper(this.registry);
    }

    private static class GuavaCacheWrapper<K, V>
    implements org.apache.shiro.cache.Cache<K, V> {
        private Cache<K, V> cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).maximumSize(1000L).concurrencyLevel(8).recordStats().build();

        public GuavaCacheWrapper(MetricRegistry registry) {
            MetricUtils.safelyRegisterAll(registry, new CacheStatsSet(MetricRegistry.name(MongoDbAuthorizationCacheManager.class, (String[])new String[]{"cache"}), this.cache));
        }

        public V get(K key) throws CacheException {
            return (V)this.cache.getIfPresent(key);
        }

        public V put(K key, V value) throws CacheException {
            Object old = this.cache.getIfPresent(key);
            this.cache.put(key, value);
            return (V)old;
        }

        public V remove(K key) throws CacheException {
            Object old = this.cache.getIfPresent(key);
            this.cache.invalidate(key);
            return (V)old;
        }

        public void clear() throws CacheException {
            this.cache.invalidateAll();
        }

        public int size() {
            return Ints.saturatedCast((long)this.cache.size());
        }

        public Set<K> keys() {
            return this.cache.asMap().keySet();
        }

        public Collection<V> values() {
            return this.cache.asMap().values();
        }
    }
}

