/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.utilities;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class StringUtils {
    private StringUtils() {
    }

    public static String f(String format, Object ... args) {
        return String.format(Locale.ENGLISH, format, args);
    }

    public static String toUpperCase(@Nullable String value) {
        if (value == null) {
            throw new IllegalArgumentException("String value cannot be null");
        }
        return value.toUpperCase(Locale.ENGLISH);
    }

    public static String toLowerCase(@Nullable String value) {
        if (value == null) {
            throw new IllegalArgumentException("String value cannot be null");
        }
        return value.toLowerCase(Locale.ENGLISH);
    }

    public static String humanReadableByteCount(long bytes) {
        String[] units = new String[]{"B", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB"};
        int base = 1024;
        if (bytes < 1024L) {
            return bytes + " " + units[0];
        }
        int exponent = (int)(Math.log(bytes) / Math.log(1024.0));
        String unit = units[exponent];
        return StringUtils.f("%.1f %s", (double)bytes / Math.pow(1024.0, exponent), unit);
    }

    public static Set<String> splitByComma(Set<String> values) {
        return StringUtils.split(values).collect(Collectors.toSet());
    }

    public static List<String> splitByComma(List<String> values) {
        return StringUtils.split(values).collect(Collectors.toList());
    }

    private static Stream<String> split(Collection<String> values) {
        if (values == null) {
            return Stream.empty();
        }
        return values.stream().filter(Objects::nonNull).flatMap(v -> Arrays.stream(v.split(","))).filter(s -> !s.trim().isEmpty());
    }
}

