/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.shutdown;

import com.google.common.util.concurrent.Uninterruptibles;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.concurrent.TimeUnit;
import org.graylog2.Configuration;
import org.graylog2.audit.AuditActor;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.initializers.BufferSynchronizerService;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.shared.initializers.InputSetupService;
import org.graylog2.shared.initializers.JerseyService;
import org.graylog2.shared.initializers.PeriodicalsService;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.graylog2.system.shutdown.GracefulShutdownService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GracefulShutdown
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(GracefulShutdown.class);
    private final Configuration configuration;
    private final BufferSynchronizerService bufferSynchronizerService;
    private final PeriodicalsService periodicalsService;
    private final InputSetupService inputSetupService;
    private final ServerStatus serverStatus;
    private final ActivityWriter activityWriter;
    private final JerseyService jerseyService;
    private final GracefulShutdownService gracefulShutdownService;
    private final AuditEventSender auditEventSender;

    @Inject
    public GracefulShutdown(ServerStatus serverStatus, ActivityWriter activityWriter, Configuration configuration, BufferSynchronizerService bufferSynchronizerService, PeriodicalsService periodicalsService, InputSetupService inputSetupService, JerseyService jerseyService, GracefulShutdownService gracefulShutdownService, AuditEventSender auditEventSender) {
        this.serverStatus = serverStatus;
        this.activityWriter = activityWriter;
        this.configuration = configuration;
        this.bufferSynchronizerService = bufferSynchronizerService;
        this.periodicalsService = periodicalsService;
        this.inputSetupService = inputSetupService;
        this.jerseyService = jerseyService;
        this.gracefulShutdownService = gracefulShutdownService;
        this.auditEventSender = auditEventSender;
    }

    @Override
    public void run() {
        this.doRun(true);
    }

    public void runWithoutExit() {
        this.doRun(false);
    }

    private void doRun(boolean exit) {
        LOG.info("Graceful shutdown initiated.");
        this.serverStatus.overrideLoadBalancerDead();
        LOG.info("Node status: [{}]. Waiting <{}sec> for possible load balancers to recognize state change.", (Object)this.serverStatus.getLifecycle(), (Object)this.configuration.getLoadBalancerRecognitionPeriodSeconds());
        Uninterruptibles.sleepUninterruptibly((long)this.configuration.getLoadBalancerRecognitionPeriodSeconds(), (TimeUnit)TimeUnit.SECONDS);
        this.activityWriter.write(new Activity("Graceful shutdown initiated.", GracefulShutdown.class));
        this.serverStatus.shutdown();
        this.jerseyService.stopAsync();
        this.inputSetupService.stopAsync();
        this.jerseyService.awaitTerminated();
        this.inputSetupService.awaitTerminated();
        this.bufferSynchronizerService.stopAsync().awaitTerminated();
        this.gracefulShutdownService.stopAsync();
        this.periodicalsService.stopAsync().awaitTerminated();
        this.gracefulShutdownService.awaitTerminated();
        this.auditEventSender.success(AuditActor.system(this.serverStatus.getNodeId()), "server:node_shutdown:complete");
        LOG.info("Goodbye.");
        if (exit) {
            System.exit(0);
        }
    }
}

