/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.users;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DuplicateKeyException;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.MongoDBUpsertRetryer;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.shared.security.Permissions;
import org.graylog2.shared.users.Role;
import org.graylog2.shared.users.Roles;
import org.graylog2.users.RoleImpl;
import org.graylog2.users.RoleService;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleServiceImpl
implements RoleService {
    private static final Logger log = LoggerFactory.getLogger(RoleServiceImpl.class);
    public static final String ROLES_COLLECTION_NAME = "roles";
    public static final String NAME_LOWER = "name_lower";
    private static final String READ_ONLY = "read_only";
    private static final String ID = "_id";
    public static final String ADMIN_ROLENAME = "Admin";
    private static final String READER_ROLENAME = "Reader";
    private final JacksonDBCollection<RoleImpl, ObjectId> dbCollection;
    private final Validator validator;
    private final String adminRoleObjectId;
    private final String readerRoleObjectId;

    @Inject
    public RoleServiceImpl(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, Permissions permissions, Validator validator) {
        this.validator = validator;
        this.dbCollection = JacksonDBCollection.wrap(mongoConnection.getDatabase().getCollection(ROLES_COLLECTION_NAME), RoleImpl.class, ObjectId.class, mapper.get());
        this.dbCollection.createIndex((DBObject)new BasicDBObject(NAME_LOWER, (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
        this.adminRoleObjectId = (String)Preconditions.checkNotNull((Object)this.ensureBuiltinRole(ADMIN_ROLENAME, Sets.newHashSet((Object[])new String[]{"*"}), ADMIN_ROLENAME, "Grants all permissions for Graylog administrators (built-in)"));
        this.readerRoleObjectId = (String)Preconditions.checkNotNull((Object)this.ensureBuiltinRole(READER_ROLENAME, permissions.readerBasePermissions(), READER_ROLENAME, "Grants basic permissions for every Graylog user (built-in)"));
    }

    @Nullable
    private String ensureBuiltinRole(String roleName, Set<String> expectedPermissions, String name, String description) {
        RoleImpl previousRole = null;
        try {
            previousRole = this.load(roleName);
            if (!previousRole.isReadOnly() || !expectedPermissions.equals(previousRole.getPermissions())) {
                String msg = "Invalid role '" + roleName + "', fixing it.";
                log.error(msg);
                throw new IllegalArgumentException(msg);
            }
        }
        catch (IllegalArgumentException | NoSuchElementException | NotFoundException ignored) {
            log.info("{} role is missing or invalid, re-adding it as a built-in role.", (Object)roleName);
            RoleImpl fixedAdmin = new RoleImpl();
            if (previousRole != null) {
                fixedAdmin._id = previousRole._id;
            }
            fixedAdmin.setReadOnly(true);
            fixedAdmin.setName(name);
            fixedAdmin.setDescription(description);
            fixedAdmin.setPermissions(expectedPermissions);
            try {
                RoleImpl savedRole = this.save(fixedAdmin);
                return savedRole.getId();
            }
            catch (DuplicateKeyException | ValidationException e) {
                log.error("Unable to save fixed " + roleName + " role, please restart Graylog to fix this.", e);
            }
        }
        if (previousRole == null) {
            log.error("Unable to access fixed " + roleName + " role, please restart Graylog to fix this.");
            return null;
        }
        return previousRole.getId();
    }

    @Override
    public Role loadById(String roleId) throws NotFoundException {
        Role role = this.dbCollection.findOneById(new ObjectId(roleId));
        if (role == null) {
            throw new NotFoundException("No role found with id " + roleId);
        }
        return role;
    }

    @Override
    public RoleImpl load(String roleName) throws NotFoundException {
        RoleImpl role = this.dbCollection.findOne((Bson)DBQuery.is((String)NAME_LOWER, (Object)roleName.toLowerCase(Locale.ENGLISH)));
        if (role == null) {
            throw new NotFoundException("No role found with name " + roleName);
        }
        return role;
    }

    @Override
    public boolean exists(String roleName) {
        return this.dbCollection.getCount((Bson)DBQuery.is((String)NAME_LOWER, (Object)roleName.toLowerCase(Locale.ENGLISH))) == 1L;
    }

    @Override
    public Set<Role> loadAll() {
        try (DBCursor<RoleImpl> rolesCursor = this.dbCollection.find();){
            ImmutableSet immutableSet = ImmutableSet.copyOf(rolesCursor);
            return immutableSet;
        }
    }

    @Override
    public Map<String, Role> findIdMap(Set<String> roleIds) throws NotFoundException {
        DBQuery.Query query = DBQuery.in((String)ID, roleIds);
        try (DBCursor<RoleImpl> rolesCursor = this.dbCollection.find((Bson)query);){
            ImmutableSet roles = ImmutableSet.copyOf(rolesCursor);
            ImmutableMap immutableMap = Maps.uniqueIndex((Iterable)roles, (Function)new Function<Role, String>(){

                @Nullable
                public String apply(Role input) {
                    return input.getId();
                }
            });
            return immutableMap;
        }
    }

    @Override
    public Map<String, Role> loadAllIdMap() throws NotFoundException {
        Set<Role> roles = this.loadAll();
        return Maps.uniqueIndex(roles, (Function)new Function<Role, String>(){

            @Nullable
            public String apply(Role input) {
                return input.getId();
            }
        });
    }

    @Override
    public Map<String, Role> loadAllLowercaseNameMap() throws NotFoundException {
        Set<Role> roles = this.loadAll();
        return Maps.uniqueIndex(roles, (Function)Roles.roleToNameFunction(true));
    }

    @Override
    public RoleImpl save(Role role1) throws ValidationException {
        if (!(role1 instanceof RoleImpl)) {
            throw new IllegalArgumentException("invalid Role implementation class");
        }
        RoleImpl role = (RoleImpl)role1;
        Set<ConstraintViolation<Role>> violations = this.validate(role);
        if (!violations.isEmpty()) {
            throw new ValidationException("Validation failed.", violations.toString());
        }
        return MongoDBUpsertRetryer.run(() -> this.dbCollection.findAndModify((Bson)DBQuery.is((String)NAME_LOWER, (Object)role.nameLower()), null, null, false, role, true, true));
    }

    @Override
    public Set<ConstraintViolation<Role>> validate(Role role) {
        return this.validator.validate((Object)role, new Class[0]);
    }

    @Override
    public int delete(String roleName) {
        DBQuery.Query nameMatchesAndNotReadonly = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)READ_ONLY, (Object)false), DBQuery.is((String)NAME_LOWER, (Object)roleName.toLowerCase(Locale.ENGLISH))});
        return this.dbCollection.remove((Bson)nameMatchesAndNotReadonly).getN();
    }

    @Override
    public String getAdminRoleObjectId() {
        return this.adminRoleObjectId;
    }

    @Override
    public String getReaderRoleObjectId() {
        return this.readerRoleObjectId;
    }
}

