/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.enterprise;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.enterprise.EnterpriseService;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Enterprise")
@Path(value="/enterprise")
@Produces(value={"application/json"})
@RequiresAuthentication
public class EnterpriseResource
extends RestResource {
    private final EnterpriseService enterpriseService;

    @Inject
    public EnterpriseResource(EnterpriseService enterpriseService) {
        this.enterpriseService = enterpriseService;
    }

    @GET
    @Timed
    @ApiOperation(value="Get Graylog Enterprise license info")
    @Path(value="/license/info")
    @RequiresPermissions(value={"licenseinfos:read"})
    public Response licenseInfo() {
        return Response.ok(Collections.singletonMap("license_info", this.enterpriseService.licenseInfo())).build();
    }
}

