/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.indices;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graylog.events.event.Event;
import org.graylog.events.event.EventWithContext;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.messages.Indexable;
import org.graylog2.indexer.messages.IndexingRequest;
import org.graylog2.indexer.messages.Messages;
import org.graylog2.plugin.database.Persisted;
import org.graylog2.streams.StreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EventIndexer {
    private static final Logger LOG = LoggerFactory.getLogger(EventIndexer.class);
    private final StreamService streamService;
    private final Messages messages;

    @Inject
    public EventIndexer(StreamService streamService, Messages messages) {
        this.streamService = streamService;
        this.messages = messages;
    }

    public void write(List<EventWithContext> eventsWithContext) {
        if (eventsWithContext.isEmpty()) {
            return;
        }
        Set<String> streamIds = this.streamIdsForEvents(eventsWithContext);
        Map<String, IndexSet> streamIndices = this.indexSetsForStreams(streamIds);
        List<IndexingRequest> requests = eventsWithContext.stream().map(EventWithContext::event).flatMap(event -> this.assignEventsToTargetIndices((Event)event, streamIndices)).map(event -> IndexingRequest.create((IndexSet)event.getKey(), (Indexable)event.getValue())).collect(Collectors.toList());
        this.messages.bulkIndexRequests(requests, true);
    }

    private Map<String, IndexSet> indexSetsForStreams(Set<String> streamIds) {
        return this.streamService.loadByIds(streamIds).stream().collect(Collectors.toMap(Persisted::getId, org.graylog2.plugin.streams.Stream::getIndexSet));
    }

    private Set<String> streamIdsForEvents(List<EventWithContext> eventsWithContext) {
        return eventsWithContext.stream().map(EventWithContext::event).flatMap(event -> event.getStreams().stream()).collect(Collectors.toSet());
    }

    private Stream<AbstractMap.SimpleEntry<IndexSet, Event>> assignEventsToTargetIndices(Event event, Map<String, IndexSet> streamIndices) {
        Set<IndexSet> indices = this.indicesForEvent(event, streamIndices);
        return indices.stream().map(index -> new AbstractMap.SimpleEntry<IndexSet, Event>((IndexSet)index, event));
    }

    private Set<IndexSet> indicesForEvent(Event event, Map<String, IndexSet> streamIndices) {
        return event.getStreams().stream().map(streamId -> {
            IndexSet index = (IndexSet)streamIndices.get(streamId);
            if (index == null) {
                LOG.warn("Couldn't find index set of stream <{}> for event <{}> (definition: {}/{})", new Object[]{streamId, event.getId(), event.getEventDefinitionType(), event.getEventDefinitionId()});
            }
            return index;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

