/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.events.contentpack.entities.EventNotificationConfigEntity;
import org.graylog.events.contentpack.entities.HttpEventNotificationConfigV2Entity;
import org.graylog.events.event.EventDto;
import org.graylog.events.notifications.EventNotificationConfig;
import org.graylog.events.notifications.EventNotificationExecutionJob;
import org.graylog.events.notifications.types.AutoValue_HTTPEventNotificationConfigV2;
import org.graylog.scheduler.JobTriggerData;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.rest.ValidationResult;
import org.graylog2.security.encryption.EncryptedValue;
import org.joda.time.DateTimeZone;

@JsonTypeName(value="http-notification-v2")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class HTTPEventNotificationConfigV2
implements EventNotificationConfig {
    public static final String TYPE_NAME = "http-notification-v2";
    public static final String FIELD_URL = "url";
    public static final String FIELD_METHOD = "method";
    public static final String FIELD_TIME_ZONE = "time_zone";
    public static final String FIELD_CONTENT_TYPE = "content_type";
    public static final String FIELD_HEADERS = "headers";
    public static final String FIELD_BODY_TEMPLATE = "body_template";
    public static final String FIELD_SKIP_TLS_VERIFICATION = "skip_tls_verification";
    private static final String FIELD_BASIC_AUTH = "basic_auth";
    private static final String FIELD_API_KEY_AS_HEADER = "api_key_as_header";
    private static final String FIELD_API_KEY = "api_key";
    private static final String FIELD_API_SECRET = "api_secret";

    @JsonProperty(value="basic_auth")
    @Nullable
    public abstract EncryptedValue basicAuth();

    @JsonProperty(value="api_key_as_header")
    public abstract boolean apiKeyAsHeader();

    @JsonProperty(value="api_key")
    @Nullable
    public abstract String apiKey();

    @JsonProperty(value="api_secret")
    @Nullable
    public abstract EncryptedValue apiSecret();

    @JsonProperty(value="url")
    public abstract String url();

    @JsonProperty(value="skip_tls_verification")
    public abstract boolean skipTLSVerification();

    @JsonProperty(value="method")
    public abstract HttpMethod httpMethod();

    @JsonProperty(value="time_zone")
    public abstract DateTimeZone timeZone();

    @JsonProperty(value="content_type")
    @Nullable
    public abstract ContentType contentType();

    @JsonProperty(value="headers")
    @Nullable
    public abstract String headers();

    @JsonProperty(value="body_template")
    @Nullable
    public abstract String bodyTemplate();

    @Override
    @JsonIgnore
    public JobTriggerData toJobTriggerData(EventDto dto) {
        return EventNotificationExecutionJob.Data.builder().eventDto(dto).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @Override
    @JsonIgnore
    public ValidationResult validate() {
        ValidationResult validation = new ValidationResult();
        if (this.url().isEmpty()) {
            validation.addError(FIELD_URL, "HTTP Notification url cannot be empty.");
        }
        if (Strings.isNullOrEmpty((String)this.apiKey()) && this.apiSecret() != null && this.apiSecret().isSet()) {
            validation.addError(FIELD_API_KEY, "HTTP Notification cannot specify API secret without API key");
        }
        if (!(Strings.isNullOrEmpty((String)this.apiKey()) || this.apiSecret() != null && (this.apiSecret().isSet() || this.apiSecret().isKeepValue()))) {
            validation.addError(FIELD_API_SECRET, "HTTP Notification cannot specify API key without API secret");
        }
        if (!Strings.isNullOrEmpty((String)this.headers())) {
            for (String nameVal : this.headers().split(";")) {
                String[] nameValArr = nameVal.split(":", 2);
                if (nameValArr.length != 2) {
                    validation.addError(FIELD_HEADERS, "Headers must be semi-colon delimited string in the form of 'Header1: Value1; Header2: Value2'");
                    break;
                }
                String name = nameValArr[0].trim();
                String val = nameValArr[1].trim();
                if (!name.isEmpty() && !val.isEmpty()) continue;
                validation.addError(FIELD_HEADERS, "Header names and values cannot be empty.");
                break;
            }
        }
        if (!this.httpMethod().equals((Object)HttpMethod.GET) && this.contentType() == null) {
            validation.addError(FIELD_CONTENT_TYPE, "Content Type must not be null for PUT/POST methods.");
        }
        if (this.contentType() == ContentType.FORM_DATA && !Strings.isNullOrEmpty((String)this.bodyTemplate())) {
            String[] parts;
            for (String part : parts = this.bodyTemplate().split("&")) {
                int equalsIndex = part.indexOf("=");
                if (equalsIndex == -1) {
                    validation.addError(FIELD_BODY_TEMPLATE, "Invalid URL encoded form data template.");
                    break;
                }
                String key = part.substring(0, equalsIndex);
                if (!key.isEmpty()) continue;
                validation.addError(FIELD_BODY_TEMPLATE, "Invalid URL encoded form data template.");
                break;
            }
        }
        return validation;
    }

    @Override
    @JsonIgnore
    public EventNotificationConfig prepareConfigUpdate(@Nonnull EventNotificationConfig newConfig) {
        HTTPEventNotificationConfigV2 newHttpConfig = (HTTPEventNotificationConfigV2)newConfig;
        EncryptedValue newBasicAuth = newHttpConfig.basicAuth();
        if (newHttpConfig.basicAuth() != null) {
            if (newHttpConfig.basicAuth().isKeepValue()) {
                newBasicAuth = this.basicAuth();
            } else if (newHttpConfig.basicAuth().isDeleteValue()) {
                newBasicAuth = EncryptedValue.createUnset();
            }
        }
        EncryptedValue newApiKeyValue = newHttpConfig.apiSecret();
        if (newHttpConfig.apiSecret() != null) {
            if (newHttpConfig.apiSecret().isKeepValue()) {
                newApiKeyValue = this.apiSecret();
            } else if (newHttpConfig.apiSecret().isDeleteValue()) {
                newApiKeyValue = EncryptedValue.createUnset();
            }
        }
        return newHttpConfig.toBuilder().apiSecret(newApiKeyValue).basicAuth(newBasicAuth).build();
    }

    @Override
    public EventNotificationConfigEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        HttpEventNotificationConfigV2Entity.Builder builder = HttpEventNotificationConfigV2Entity.builder().url(ValueReference.of(this.url())).skipTLSVerification(ValueReference.of(this.skipTLSVerification())).httpMethod(ValueReference.of(this.httpMethod())).timeZone(ValueReference.of(this.timeZone().getID())).headers(ValueReference.of(this.headers()));
        if (this.contentType() != null) {
            builder.contentType(ValueReference.of(this.contentType()));
            if (this.bodyTemplate() != null) {
                builder.bodyTemplate(ValueReference.of(this.bodyTemplate()));
            }
        }
        return builder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements EventNotificationConfig.Builder<Builder> {
        @JsonCreator
        public static Builder create() {
            return ((Builder)new AutoValue_HTTPEventNotificationConfigV2.Builder().basicAuth(EncryptedValue.createUnset()).apiSecret(EncryptedValue.createUnset()).apiKey("").apiKeyAsHeader(false).skipTLSVerification(false).type(HTTPEventNotificationConfigV2.TYPE_NAME)).httpMethod(HttpMethod.POST).contentType(ContentType.JSON).bodyTemplate("").timeZone(DateTimeZone.UTC);
        }

        @JsonProperty(value="basic_auth")
        public abstract Builder basicAuth(EncryptedValue var1);

        @JsonProperty(value="api_key_as_header")
        public abstract Builder apiKeyAsHeader(boolean var1);

        @JsonProperty(value="api_key")
        public abstract Builder apiKey(String var1);

        @JsonProperty(value="api_secret")
        public abstract Builder apiSecret(EncryptedValue var1);

        @JsonProperty(value="url")
        public abstract Builder url(String var1);

        @JsonProperty(value="skip_tls_verification")
        public abstract Builder skipTLSVerification(boolean var1);

        @JsonProperty(value="method")
        public abstract Builder httpMethod(HttpMethod var1);

        @JsonProperty(value="time_zone")
        public abstract Builder timeZone(DateTimeZone var1);

        @JsonProperty(value="content_type")
        public abstract Builder contentType(ContentType var1);

        @JsonProperty(value="headers")
        public abstract Builder headers(String var1);

        @JsonProperty(value="body_template")
        public abstract Builder bodyTemplate(String var1);

        public abstract HTTPEventNotificationConfigV2 build();
    }

    public static enum HttpMethod {
        POST,
        PUT,
        GET;

    }

    public static enum ContentType {
        JSON,
        FORM_DATA,
        PLAIN_TEXT;

    }
}

