/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.aws.codecs;

import com.google.inject.assistedinject.Assisted;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.integrations.aws.AWSMessageType;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.BooleanField;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.DropdownField;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.AbstractCodec;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.journal.RawMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;

public class AWSCodec
extends AbstractCodec {
    public static final String NAME = "AWSCodec";
    private static final Logger LOG = LoggerFactory.getLogger(AWSCodec.class);
    public static final String CK_AWS_MESSAGE_TYPE = "aws_message_type";
    public static final String CK_FLOW_LOG_PREFIX = "aws_flow_log_prefix";
    static final boolean FLOW_LOG_PREFIX_DEFAULT = true;
    private final Map<String, Codec.Factory<? extends Codec>> availableCodecs;

    @Inject
    public AWSCodec(@Assisted Configuration configuration, Map<String, Codec.Factory<? extends Codec>> availableCodecs) {
        super(configuration);
        this.availableCodecs = availableCodecs;
    }

    @Override
    @Nullable
    public Message decode(@Nonnull RawMessage rawMessage) {
        AWSMessageType awsMessageType = AWSMessageType.valueOf(this.configuration.getString(CK_AWS_MESSAGE_TYPE));
        Codec.Factory<? extends Codec> codecFactory = this.availableCodecs.get(awsMessageType.getCodecName());
        if (codecFactory == null) {
            LOG.error("A codec with name [{}] could not be found.", (Object)awsMessageType.getCodecName());
            return null;
        }
        Codec codec = codecFactory.create(this.configuration);
        Message message = codec.decode(new RawMessage(rawMessage.getPayload()));
        if (message == null) {
            LOG.error("Failed to decode message for codec [{}].", (Object)codec.getName());
            return null;
        }
        return message;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @ConfigClass
    public static class Config
    extends AbstractCodec.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest request = new ConfigurationRequest();
            request.addField(new DropdownField(AWSCodec.CK_AWS_MESSAGE_TYPE, "AWS Message Type", Region.US_EAST_1.id(), AWSMessageType.getMessageTypes().stream().collect(Collectors.toMap(Enum::toString, AWSMessageType::getLabel)), "The type of AWS message that this input will receive.", ConfigurationField.Optional.NOT_OPTIONAL));
            request.addField(new BooleanField(AWSCodec.CK_FLOW_LOG_PREFIX, "Add Flow Log field name prefix", true, "Add field with the Flow Log prefix e. g. \"src_addr\" -> \"flow_log_src_addr\"."));
            return request;
        }

        @Override
        public void overrideDefaultValues(@Nonnull ConfigurationRequest cr) {
        }
    }

    @FactoryClass
    public static interface Factory
    extends Codec.Factory<AWSCodec> {
        @Override
        public AWSCodec create(Configuration var1);

        @Override
        public Config getConfig();
    }
}

