/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.aws.transports;

import com.codahale.metrics.MetricSet;
import com.google.common.eventbus.EventBus;
import com.google.inject.assistedinject.Assisted;
import jakarta.inject.Inject;
import java.util.Locale;
import java.util.Map;
import org.graylog.integrations.aws.AWSMessageType;
import org.graylog2.plugin.InputFailureRecorder;
import org.graylog2.plugin.LocalMetricRegistry;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.MisfireException;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.graylog2.plugin.inputs.transports.ThrottleableTransport;
import org.graylog2.plugin.inputs.transports.ThrottleableTransport2;
import org.graylog2.plugin.inputs.transports.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWSTransport
extends ThrottleableTransport2 {
    private static final Logger LOG = LoggerFactory.getLogger(AWSTransport.class);
    public static final String NAME = "aws-transport";
    private final LocalMetricRegistry localRegistry;
    private final Map<String, Transport.Factory<? extends Transport>> availableTransports;
    private final Configuration configuration;
    private Transport resolvedTransport;

    @Inject
    public AWSTransport(@Assisted Configuration configuration, EventBus serverEventBus, LocalMetricRegistry localRegistry, Map<String, Transport.Factory<? extends Transport>> availableTransports) {
        super(serverEventBus, configuration);
        this.configuration = configuration;
        this.localRegistry = localRegistry;
        this.availableTransports = availableTransports;
    }

    @Override
    public void doLaunch(MessageInput input, InputFailureRecorder inputFailureRecorder) throws MisfireException {
        LOG.debug("Start AWS Transport");
        Transport transport = this.resolveTransport();
        transport.launch(input, inputFailureRecorder);
        this.resolvedTransport = transport;
    }

    @Override
    public void doStop() {
        LOG.debug("Stop AWS Transport");
        if (this.resolvedTransport == null) {
            LOG.error("A transport was not found with this [{}] instance.", (Object)this.configuration.getString("aws_message_type"));
        }
        this.resolvedTransport.stop();
    }

    private Transport resolveTransport() throws MisfireException {
        AWSMessageType awsMessageType = AWSMessageType.valueOf(this.configuration.getString("aws_message_type"));
        Transport.Factory<? extends Transport> transportFactory = this.availableTransports.get(awsMessageType.getTransportName());
        if (transportFactory == null) {
            throw new MisfireException(String.format(Locale.ROOT, "A transport with name [%s] could not be found.", awsMessageType.getTransportName()));
        }
        return transportFactory.create(this.configuration);
    }

    @Override
    public void setMessageAggregator(CodecAggregator aggregator) {
    }

    @Override
    public MetricSet getMetricSet() {
        return this.localRegistry;
    }

    @ConfigClass
    public static class Config
    extends ThrottleableTransport.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            return super.getRequestedConfiguration();
        }
    }

    @FactoryClass
    public static interface Factory
    extends Transport.Factory<AWSTransport> {
        @Override
        public AWSTransport create(Configuration var1);

        @Override
        public Config getConfig();
    }
}

