/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.inputs.paloalto;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.graylog.integrations.inputs.paloalto.PaloAltoFieldTemplate;
import org.graylog.integrations.inputs.paloalto.PaloAltoFieldType;
import org.graylog.integrations.inputs.paloalto.PaloAltoMessageTemplate;
import org.graylog.integrations.inputs.paloalto.PaloAltoMessageType;
import org.graylog.integrations.inputs.paloalto.PaloAltoTemplateDefaults;
import org.graylog2.plugin.inputs.MisfireException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaloAltoTemplates {
    public static final String INVALID_TEMPLATE_ERROR = "[%s] Palo Alto input template is invalid.";
    private PaloAltoMessageTemplate systemMessageTemplate;
    private PaloAltoMessageTemplate threatMessageTemplate;
    private PaloAltoMessageTemplate trafficMessageTemplate;
    private static final Logger LOG = LoggerFactory.getLogger(PaloAltoTemplates.class);

    public static PaloAltoTemplates newInstance(String systemCsv, String threatCsv, String trafficCsv) {
        PaloAltoTemplates builder = new PaloAltoTemplates();
        String systemTemplate = StringUtils.isNotBlank((CharSequence)systemCsv) ? systemCsv : PaloAltoTemplateDefaults.SYSTEM_TEMPLATE;
        String threatTemplate = StringUtils.isNotBlank((CharSequence)threatCsv) ? threatCsv : PaloAltoTemplateDefaults.THREAT_TEMPLATE;
        String trafficTemplate = StringUtils.isNotBlank((CharSequence)trafficCsv) ? trafficCsv : PaloAltoTemplateDefaults.TRAFFIC_TEMPLATE;
        builder.systemMessageTemplate = PaloAltoTemplates.readCSV(systemTemplate, PaloAltoMessageType.SYSTEM);
        builder.threatMessageTemplate = PaloAltoTemplates.readCSV(threatTemplate, PaloAltoMessageType.THREAT);
        builder.trafficMessageTemplate = PaloAltoTemplates.readCSV(trafficTemplate, PaloAltoMessageType.TRAFFIC);
        return builder;
    }

    private static PaloAltoMessageTemplate readCSV(String csvString, PaloAltoMessageType messageType) {
        PaloAltoMessageTemplate template = new PaloAltoMessageTemplate();
        StringReader stringReader = new StringReader(csvString);
        CSVParser parser = null;
        List list = null;
        try {
            parser = new CSVParser((Reader)stringReader, CSVFormat.DEFAULT);
            list = parser.getRecords();
        }
        catch (IOException e) {
            template.addError(String.format(Locale.ENGLISH, "Failed to parse [%s] CSV. Error [%s/%s] CSV [%s].", new Object[]{messageType, ExceptionUtils.getMessage((Throwable)e), ExceptionUtils.getRootCause((Throwable)e), csvString}));
            return template;
        }
        if (list.isEmpty()) {
            template.addError(String.format(Locale.ENGLISH, "The header row is missing. It must include the following fields: [%s,%s,%s].", PaloAltoTemplateDefaults.POSITION, PaloAltoTemplateDefaults.FIELD, PaloAltoTemplateDefaults.TYPE));
        }
        if (template.hasErrors()) {
            return template;
        }
        if (!list.stream().findFirst().filter(row -> row.toString().contains(PaloAltoTemplateDefaults.POSITION)).isPresent()) {
            template.addError(String.format(Locale.ENGLISH, "The header row is invalid. It must include the [%s] field.", PaloAltoTemplateDefaults.POSITION));
        }
        if (!list.stream().findFirst().filter(row -> row.toString().contains(PaloAltoTemplateDefaults.FIELD)).isPresent()) {
            template.addError(String.format(Locale.ENGLISH, "The header row is invalid. It must include the [%s] field.", PaloAltoTemplateDefaults.FIELD));
        }
        if (!list.stream().findFirst().filter(row -> row.toString().contains(PaloAltoTemplateDefaults.TYPE)).isPresent()) {
            template.addError(String.format(Locale.ENGLISH, "The header row is invalid. It must include the [%s] field.", PaloAltoTemplateDefaults.TYPE));
        }
        if (template.hasErrors()) {
            return template;
        }
        LOG.trace("Parsing CSV header.");
        CSVRecord headerRow = (CSVRecord)list.get(0);
        int positionIndex = IntStream.range(0, headerRow.size()).filter(i -> PaloAltoTemplateDefaults.POSITION.equals(headerRow.get(i))).findFirst().getAsInt();
        int fieldIndex = IntStream.range(0, headerRow.size()).filter(i -> PaloAltoTemplateDefaults.FIELD.equals(headerRow.get(i))).findFirst().getAsInt();
        int typeIndex = IntStream.range(0, headerRow.size()).filter(i -> PaloAltoTemplateDefaults.TYPE.equals(headerRow.get(i))).findFirst().getAsInt();
        if (list.size() <= 1) {
            LOG.error("No fields were specified for the [{}] message type.", (Object)messageType);
            return template;
        }
        LOG.trace("Parsing CSV rows");
        int rowIndex = 0;
        for (CSVRecord row2 : list) {
            String typeString;
            boolean typeIsValid;
            String positionString;
            boolean positionIsValid;
            if (++rowIndex == 1) continue;
            if (headerRow.size() < 2) {
                template.addError(String.format(Locale.ENGLISH, "LINE %d: Row [%s] must contain [%d] comma-separated values", rowIndex, row2.toString(), row2.size()));
                continue;
            }
            String fieldString = row2.size() >= 1 ? row2.get(fieldIndex) : "";
            boolean fieldIsValid = StringUtils.isNotBlank((CharSequence)fieldString);
            if (!fieldIsValid) {
                template.addError(String.format(Locale.ENGLISH, "LINE %d: The [%s] value must not be blank", rowIndex, PaloAltoTemplateDefaults.FIELD));
            }
            if (!(positionIsValid = StringUtils.isNumeric((CharSequence)(positionString = row2.size() >= 2 ? row2.get(positionIndex) : "")))) {
                template.addError(String.format(Locale.ENGLISH, "LINE %d: [%s] is not a valid positive integer value for [%s]", rowIndex, positionString, PaloAltoTemplateDefaults.POSITION));
            }
            if (!(typeIsValid = EnumUtils.isValidEnum(PaloAltoFieldType.class, (String)(typeString = row2.size() >= 3 ? row2.get(typeIndex) : "")))) {
                template.addError(String.format(Locale.ENGLISH, "LINE %d: [%s] is not a valid [%s] value. Valid values are [%s, %s, %s]", new Object[]{rowIndex, typeString, PaloAltoTemplateDefaults.TYPE, PaloAltoFieldType.BOOLEAN, PaloAltoFieldType.LONG, PaloAltoFieldType.STRING}));
            }
            if (!fieldIsValid || !positionIsValid || !typeIsValid) continue;
            template.getFields().add(PaloAltoFieldTemplate.create(fieldString, Integer.valueOf(positionString), PaloAltoFieldType.valueOf(typeString)));
        }
        return template;
    }

    private static void checkErrors(PaloAltoMessageType messageType, List<String> errors) throws MisfireException {
        errors.add(0, String.format(Locale.ENGLISH, "Error validating the [%s] CSV message template:", new Object[]{messageType}));
        throw new MisfireException(String.join((CharSequence)"\n", errors));
    }

    public PaloAltoMessageTemplate getSystemMessageTemplate() {
        return this.systemMessageTemplate;
    }

    public PaloAltoMessageTemplate getThreatMessageTemplate() {
        return this.threatMessageTemplate;
    }

    public PaloAltoMessageTemplate getTrafficMessageTemplate() {
        return this.trafficMessageTemplate;
    }

    public List<String> getAllErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.systemMessageTemplate != null) {
            errors.addAll(this.systemMessageTemplate.getParseErrors());
        }
        if (this.threatMessageTemplate != null) {
            errors.addAll(this.threatMessageTemplate.getParseErrors());
        }
        if (this.trafficMessageTemplate.getParseErrors() != null) {
            errors.addAll(this.trafficMessageTemplate.getParseErrors());
        }
        return errors;
    }

    public String errorMessageSummary(String delimiter) {
        ArrayList<String> errors = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(this.systemMessageTemplate.getParseErrors())) {
            errors.add(String.format(Locale.ENGLISH, INVALID_TEMPLATE_ERROR, new Object[]{PaloAltoMessageType.SYSTEM}));
            errors.addAll(this.systemMessageTemplate.getParseErrors());
        }
        if (CollectionUtils.isNotEmpty(this.threatMessageTemplate.getParseErrors())) {
            errors.add(String.format(Locale.ENGLISH, INVALID_TEMPLATE_ERROR, new Object[]{PaloAltoMessageType.THREAT}));
            errors.addAll(this.threatMessageTemplate.getParseErrors());
        }
        if (CollectionUtils.isNotEmpty(this.trafficMessageTemplate.getParseErrors())) {
            errors.add(String.format(Locale.ENGLISH, INVALID_TEMPLATE_ERROR, new Object[]{PaloAltoMessageType.TRAFFIC}));
            errors.addAll(this.trafficMessageTemplate.getParseErrors());
        }
        return errors.stream().collect(Collectors.joining(delimiter));
    }

    public boolean hasErrors() {
        return !this.getAllErrors().isEmpty();
    }
}

