/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.arrays;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.functions.arrays.AbstractArrayFunction;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayRemove
extends AbstractArrayFunction<List> {
    public static final String NAME = "array_remove";
    private static final Logger LOG = LoggerFactory.getLogger(ArrayRemove.class);
    private static final String VALUE_MISSING_MESSAGE = "Value [{}] was not present in array.";
    private final ParameterDescriptor<Object, List> elementsParam = ParameterDescriptor.type("elements", Object.class, List.class).transform(AbstractArrayFunction::toList).description("The input array, all must have the same data type, may be null").build();
    private final ParameterDescriptor<Object, Object> valueParam = ParameterDescriptor.object("value").description("The value to remove from the array").build();
    private final ParameterDescriptor<Boolean, Boolean> removeAllParam = ParameterDescriptor.bool("remove_all").optional().description("Whether or not to remove all elements, or just a single one").build();

    @Override
    public List evaluate(FunctionArgs args, EvaluationContext context) {
        ArrayList elements = new ArrayList(this.elementsParam.optional(args, context).orElse(Collections.emptyList()));
        Object value = this.valueParam.required(args, context);
        boolean removeAll = this.removeAllParam.optional(args, context).orElse(false);
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        if (removeAll) {
            if (!elements.removeAll(Collections.singleton(value))) {
                LOG.trace(VALUE_MISSING_MESSAGE, value);
            }
            return elements;
        }
        if (!elements.remove(value)) {
            LOG.trace(VALUE_MISSING_MESSAGE, value);
        }
        return elements;
    }

    @Override
    public FunctionDescriptor<List> descriptor() {
        return FunctionDescriptor.builder().name(NAME).pure(true).returnType(List.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.elementsParam, this.valueParam, this.removeAllParam)).description("Removes the specified element from the array.").ruleBuilderEnabled().ruleBuilderName("Remove element from array").ruleBuilderTitle("Remove '${value}' from array '${elements}'").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.ARRAY).build();
    }
}

