/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.lookup;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;

public class ListCount
extends AbstractFunction<Object> {
    public static final String NAME = "list_count";
    private static final String LISTARG = "list";
    private final ParameterDescriptor<List, List> listParam = ParameterDescriptor.type("list", List.class).description("A list").build();

    @Override
    public Object evaluate(FunctionArgs args, EvaluationContext context) {
        List listValue = this.listParam.required(args, context);
        if (listValue == null) {
            return 0L;
        }
        return Integer.toUnsignedLong(listValue.size());
    }

    @Override
    public FunctionDescriptor<Object> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Long.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.listParam)).description("Get number of elements in list").ruleBuilderEnabled().ruleBuilderName("Get list size").ruleBuilderTitle("Count elements in list '${list}'").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.OTHER).build();
    }
}

